/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.bundle.BundleVerifier;
import dev.sigstore.proto.ProtoMutators;
import dev.sigstore.proto.bundle.v1.Bundle;
import dev.sigstore.proto.bundle.v1.VerificationMaterial;
import dev.sigstore.proto.common.v1.HashOutput;
import dev.sigstore.proto.common.v1.LogId;
import dev.sigstore.proto.common.v1.MessageSignature;
import dev.sigstore.proto.common.v1.X509Certificate;
import dev.sigstore.proto.rekor.v1.Checkpoint;
import dev.sigstore.proto.rekor.v1.InclusionPromise;
import dev.sigstore.proto.rekor.v1.InclusionProof;
import dev.sigstore.proto.rekor.v1.KindVersion;
import dev.sigstore.proto.rekor.v1.TransparencyLogEntry;
import dev.sigstore.rekor.client.RekorEntry;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

class BundleWriter {
    static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer();

    BundleWriter() {
    }

    static String writeBundle(Bundle signingResult) {
        dev.sigstore.proto.bundle.v1.Bundle bundle = BundleWriter.createBundleBuilder(signingResult).build();
        try {
            String jsonBundle = JSON_PRINTER.print((MessageOrBuilder)bundle);
            List<String> missingFields = BundleVerifier.findMissingFields(bundle);
            if (!missingFields.isEmpty()) {
                throw new IllegalStateException("Some of the fields were not initialized: " + String.join((CharSequence)", ", missingFields) + "; bundle JSON: " + jsonBundle);
            }
            return jsonBundle;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't serialize signing result to Sigstore Bundle JSON", e);
        }
    }

    static Bundle.Builder createBundleBuilder(Bundle bundle) {
        if (bundle.getMessageSignature().isEmpty()) {
            throw new IllegalStateException("can only serialize bundles with message signatures");
        }
        Bundle.MessageSignature messageSignature = bundle.getMessageSignature().get();
        if (messageSignature.getMessageDigest().isEmpty()) {
            throw new IllegalStateException("keyless signature must have artifact digest when serializing to bundle");
        }
        return dev.sigstore.proto.bundle.v1.Bundle.newBuilder().setMediaType(bundle.getMediaType()).setVerificationMaterial(BundleWriter.buildVerificationMaterial(bundle)).setMessageSignature(MessageSignature.newBuilder().setMessageDigest(HashOutput.newBuilder().setAlgorithm(ProtoMutators.from(messageSignature.getMessageDigest().get().getHashAlgorithm())).setDigest(ByteString.copyFrom((byte[])messageSignature.getMessageDigest().get().getDigest()))).setSignature(ByteString.copyFrom((byte[])messageSignature.getSignature())));
    }

    private static VerificationMaterial.Builder buildVerificationMaterial(Bundle bundle) {
        X509Certificate cert;
        Certificate javaCert = (Certificate)Iterables.getLast(bundle.getCertPath().getCertificates());
        try {
            cert = ProtoMutators.fromCert((java.security.cert.X509Certificate)javaCert);
        }
        catch (CertificateEncodingException ce) {
            throw new IllegalArgumentException("Cannot encode certificate " + javaCert, ce);
        }
        VerificationMaterial.Builder builder = VerificationMaterial.newBuilder().setCertificate(cert);
        if (bundle.getEntries().size() != 1) {
            throw new IllegalArgumentException("Exactly 1 rekor entry must be present in the signing result");
        }
        builder.addTlogEntries(BundleWriter.buildTlogEntries(bundle.getEntries().get(0)));
        return builder;
    }

    private static TransparencyLogEntry.Builder buildTlogEntries(RekorEntry entry) {
        TransparencyLogEntry.Builder transparencyLogEntry = TransparencyLogEntry.newBuilder().setLogIndex(entry.getLogIndex()).setLogId(LogId.newBuilder().setKeyId(ByteString.fromHex((String)entry.getLogID()))).setKindVersion(KindVersion.newBuilder().setKind(entry.getBodyDecoded().getKind()).setVersion(entry.getBodyDecoded().getApiVersion())).setIntegratedTime(entry.getIntegratedTime()).setInclusionPromise(InclusionPromise.newBuilder().setSignedEntryTimestamp(ByteString.copyFrom((byte[])Base64.getDecoder().decode(entry.getVerification().getSignedEntryTimestamp())))).setCanonicalizedBody(ByteString.copyFrom((byte[])Base64.getDecoder().decode(entry.getBody())));
        BundleWriter.addInclusionProof(transparencyLogEntry, entry);
        return transparencyLogEntry;
    }

    private static void addInclusionProof(TransparencyLogEntry.Builder transparencyLogEntry, RekorEntry entry) {
        RekorEntry.InclusionProof inclusionProof = entry.getVerification().getInclusionProof();
        transparencyLogEntry.setInclusionProof(InclusionProof.newBuilder().setLogIndex(inclusionProof.getLogIndex()).setRootHash(ByteString.fromHex((String)inclusionProof.getRootHash())).setTreeSize(inclusionProof.getTreeSize()).addAllHashes(inclusionProof.getHashes().stream().map(ByteString::fromHex).collect(Collectors.toList())).setCheckpoint(Checkpoint.newBuilder().setEnvelope(inclusionProof.getCheckpoint())));
    }
}

