/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.bundle.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Bundle.DsseEnvelope", generator="Immutables")
@Immutable
public final class ImmutableDsseEnvelope
implements Bundle.DsseEnvelope {
    private final byte[] payload;
    private final String payloadType;
    private final ImmutableList<Bundle.DsseEnvelope.Signature> signatures;
    private final transient byte[] pAE;
    private volatile transient long lazyInitBitmap;
    private static final long PAYLOAD_AS_STRING_LAZY_INIT_BIT = 1L;
    private transient String payloadAsString;
    private static final long SIGNATURE_LAZY_INIT_BIT = 2L;
    private transient byte[] signature;

    private ImmutableDsseEnvelope(byte[] payload, String payloadType, ImmutableList<Bundle.DsseEnvelope.Signature> signatures) {
        this.payload = payload;
        this.payloadType = payloadType;
        this.signatures = signatures;
        this.pAE = Objects.requireNonNull(Bundle.DsseEnvelope.super.getPAE(), "pAE");
    }

    @Override
    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    @Override
    public String getPayloadType() {
        return this.payloadType;
    }

    public ImmutableList<Bundle.DsseEnvelope.Signature> getSignatures() {
        return this.signatures;
    }

    @Override
    public byte[] getPAE() {
        return this.pAE;
    }

    public final ImmutableDsseEnvelope withPayload(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableDsseEnvelope(newValue, this.payloadType, this.signatures);
    }

    public final ImmutableDsseEnvelope withPayloadType(String value) {
        String newValue = Objects.requireNonNull(value, "payloadType");
        if (this.payloadType.equals(newValue)) {
            return this;
        }
        return new ImmutableDsseEnvelope(this.payload, newValue, this.signatures);
    }

    public final ImmutableDsseEnvelope withSignatures(Bundle.DsseEnvelope.Signature ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDsseEnvelope(this.payload, this.payloadType, (ImmutableList<Bundle.DsseEnvelope.Signature>)newValue);
    }

    public final ImmutableDsseEnvelope withSignatures(Iterable<? extends Bundle.DsseEnvelope.Signature> elements) {
        if (this.signatures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDsseEnvelope(this.payload, this.payloadType, (ImmutableList<Bundle.DsseEnvelope.Signature>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsseEnvelope && this.equalTo(0, (ImmutableDsseEnvelope)another);
    }

    private boolean equalTo(int synthetic, ImmutableDsseEnvelope another) {
        return Arrays.equals(this.payload, another.payload) && this.payloadType.equals(another.payloadType) && this.signatures.equals(another.signatures) && this.pAE.equals(another.pAE);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.payload);
        h += (h << 5) + this.payloadType.hashCode();
        h += (h << 5) + this.signatures.hashCode();
        h += (h << 5) + this.pAE.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DsseEnvelope").omitNullValues().add("payload", (Object)Arrays.toString(this.payload)).add("payloadType", (Object)this.payloadType).add("signatures", this.signatures).add("pAE", (Object)this.pAE).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPayloadAsString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDsseEnvelope immutableDsseEnvelope = this;
            synchronized (immutableDsseEnvelope) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.payloadAsString = Objects.requireNonNull(Bundle.DsseEnvelope.super.getPayloadAsString(), "payloadAsString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.payloadAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSignature() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableDsseEnvelope immutableDsseEnvelope = this;
            synchronized (immutableDsseEnvelope) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.signature = Objects.requireNonNull(Bundle.DsseEnvelope.super.getSignature(), "signature");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.signature;
    }

    public static ImmutableDsseEnvelope copyOf(Bundle.DsseEnvelope instance) {
        if (instance instanceof ImmutableDsseEnvelope) {
            return (ImmutableDsseEnvelope)instance;
        }
        return ImmutableDsseEnvelope.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bundle.DsseEnvelope", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private static final long INIT_BIT_PAYLOAD_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private byte[] payload;
        @Nullable
        private String payloadType;
        private ImmutableList.Builder<Bundle.DsseEnvelope.Signature> signatures = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bundle.DsseEnvelope instance) {
            Objects.requireNonNull(instance, "instance");
            this.payload(instance.getPayload());
            this.payloadType(instance.getPayloadType());
            this.addAllSignatures(instance.getSignatures());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(byte ... payload) {
            this.payload = (byte[])payload.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payloadType(String payloadType) {
            this.payloadType = Objects.requireNonNull(payloadType, "payloadType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(Bundle.DsseEnvelope.Signature element) {
            this.signatures.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(Bundle.DsseEnvelope.Signature ... elements) {
            this.signatures.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatures(Iterable<? extends Bundle.DsseEnvelope.Signature> elements) {
            this.signatures = ImmutableList.builder();
            return this.addAllSignatures(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignatures(Iterable<? extends Bundle.DsseEnvelope.Signature> elements) {
            this.signatures.addAll(elements);
            return this;
        }

        public ImmutableDsseEnvelope build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDsseEnvelope(this.payload, this.payloadType, (ImmutableList<Bundle.DsseEnvelope.Signature>)this.signatures.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payloadType");
            }
            return "Cannot build DsseEnvelope, some of required attributes are not set " + attributes;
        }
    }
}

