/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.certificates.transparency;

import dev.sigstore.encryption.certificates.transparency.CTLogInfo;
import dev.sigstore.encryption.certificates.transparency.CTLogStore;
import dev.sigstore.encryption.certificates.transparency.CTVerificationResult;
import dev.sigstore.encryption.certificates.transparency.CertificateEntry;
import dev.sigstore.encryption.certificates.transparency.Serialization;
import dev.sigstore.encryption.certificates.transparency.SerializationException;
import dev.sigstore.encryption.certificates.transparency.SignedCertificateTimestamp;
import dev.sigstore.encryption.certificates.transparency.VerifiedSCT;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CTVerifier {
    private final CTLogStore store;

    public CTVerifier(CTLogStore store) {
        this.store = store;
    }

    public CTVerificationResult verifySignedCertificateTimestamps(List<X509Certificate> chain, byte[] tlsData, byte[] ocspData) throws CertificateEncodingException {
        if (chain.size() == 0) {
            throw new IllegalArgumentException("Chain of certificates mustn't be empty.");
        }
        X509Certificate leaf = chain.get(0);
        CTVerificationResult result = new CTVerificationResult();
        List<SignedCertificateTimestamp> embeddedScts = this.getSCTsFromX509Extension(leaf);
        this.verifyEmbeddedSCTs(embeddedScts, chain, result);
        return result;
    }

    private void verifyEmbeddedSCTs(List<SignedCertificateTimestamp> scts, List<X509Certificate> chain, CTVerificationResult result) {
        if (scts.isEmpty()) {
            return;
        }
        CertificateEntry precertEntry = null;
        if (chain.size() >= 2) {
            X509Certificate leaf = chain.get(0);
            X509Certificate issuer = chain.get(1);
            try {
                precertEntry = CertificateEntry.createForPrecertificate(leaf, issuer);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        if (precertEntry == null) {
            this.markSCTsAsInvalid(scts, result);
            return;
        }
        for (SignedCertificateTimestamp sct : scts) {
            VerifiedSCT.Status status = this.verifySingleSCT(sct, precertEntry);
            result.add(new VerifiedSCT(sct, status));
        }
    }

    public VerifiedSCT.Status verifySingleSCT(SignedCertificateTimestamp sct, CertificateEntry certEntry) {
        CTLogInfo log = this.store.getKnownLog(sct.getLogID());
        if (log == null) {
            return VerifiedSCT.Status.UNKNOWN_LOG;
        }
        return log.verifySingleSCT(sct, certEntry);
    }

    private void markSCTsAsInvalid(List<SignedCertificateTimestamp> scts, CTVerificationResult result) {
        for (SignedCertificateTimestamp sct : scts) {
            result.add(new VerifiedSCT(sct, VerifiedSCT.Status.INVALID_SCT));
        }
    }

    private static List<SignedCertificateTimestamp> getSCTsFromSCTList(byte[] data, SignedCertificateTimestamp.Origin origin) {
        byte[][] sctList;
        if (data == null) {
            return Collections.emptyList();
        }
        try {
            sctList = Serialization.readList(data, 2, 2);
        }
        catch (SerializationException e) {
            return Collections.emptyList();
        }
        ArrayList<SignedCertificateTimestamp> scts = new ArrayList<SignedCertificateTimestamp>();
        for (byte[] encodedSCT : sctList) {
            try {
                SignedCertificateTimestamp sct = SignedCertificateTimestamp.decode(encodedSCT, origin);
                scts.add(sct);
            }
            catch (SerializationException serializationException) {
                // empty catch block
            }
        }
        return scts;
    }

    private List<SignedCertificateTimestamp> getSCTsFromX509Extension(X509Certificate leaf) {
        byte[] extData = leaf.getExtensionValue("1.3.6.1.4.1.11129.2.4.2");
        if (extData == null) {
            return Collections.emptyList();
        }
        try {
            return CTVerifier.getSCTsFromSCTList(Serialization.readDEROctetString(Serialization.readDEROctetString(extData)), SignedCertificateTimestamp.Origin.EMBEDDED);
        }
        catch (SerializationException e) {
            return Collections.emptyList();
        }
    }
}

