/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.encryption.signers.RsaSigner;
import dev.sigstore.encryption.signers.Verifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class RsaVerifier
implements Verifier {
    private final PublicKey publicKey;

    RsaVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean verify(byte[] artifact, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature verifier = Signature.getInstance("SHA256withRSA");
        verifier.initVerify(this.publicKey);
        verifier.update(artifact);
        return verifier.verify(signature);
    }

    @Override
    public boolean verifyDigest(byte[] digest, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature verifier = Signature.getInstance("NONEwithRSA");
        verifier.initVerify(this.publicKey);
        verifier.update(RsaSigner.PKCS1_SHA256_PADDING);
        verifier.update(digest);
        return verifier.verify(signature);
    }
}

