/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.proto.common.v1.HashAlgorithm;
import dev.sigstore.proto.common.v1.X509Certificate;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class ProtoMutators {
    public static CertPath toCertPath(List<X509Certificate> certificates) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> converted = new ArrayList<Certificate>(certificates.size());
        for (X509Certificate cert : certificates) {
            converted.add(Certificates.fromDer(cert.getRawBytes().toByteArray()));
        }
        return cf.generateCertPath(converted);
    }

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static X509Certificate fromCert(java.security.cert.X509Certificate certificate) throws CertificateEncodingException {
        byte[] encoded = certificate.getEncoded();
        return X509Certificate.newBuilder().setRawBytes(ByteString.copyFrom((byte[])encoded)).build();
    }

    public static HashAlgorithm from(Bundle.HashAlgorithm algorithm) {
        if (algorithm == Bundle.HashAlgorithm.SHA2_256) {
            return HashAlgorithm.SHA2_256;
        }
        throw new IllegalStateException("Unknown hash algorithm: " + algorithm);
    }
}

