/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.hash.Hashing;
import com.google.common.primitives.Bytes;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.hashedRekord.v0_0_1.Data;
import dev.sigstore.rekor.hashedRekord.v0_0_1.Hash;
import dev.sigstore.rekor.hashedRekord.v0_0_1.HashedRekord;
import dev.sigstore.rekor.hashedRekord.v0_0_1.PublicKey;
import dev.sigstore.rekor.hashedRekord.v0_0_1.Signature;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.bouncycastle.util.encoders.Hex;
import org.erdtman.jcs.JsonCanonicalizer;

public class HashedRekordRequest {
    private final HashedRekord hashedRekord;

    private HashedRekordRequest(HashedRekord hashedRekord) {
        this.hashedRekord = hashedRekord;
    }

    public static HashedRekordRequest newHashedRekordRequest(byte[] artifactDigest, byte[] publicKey, byte[] signature) {
        return new HashedRekordRequest(new HashedRekord().withData(new Data().withHash(new Hash().withValue(new String(Hex.encode((byte[])artifactDigest), StandardCharsets.ISO_8859_1)).withAlgorithm(Hash.Algorithm.SHA_256))).withSignature(new Signature().withContent(Base64.getEncoder().encodeToString(signature)).withPublicKey(new PublicKey().withContent(Base64.getEncoder().encodeToString(publicKey)))));
    }

    public String toJsonPayload() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("kind", "hashedrekord");
        data.put("apiVersion", "0.0.1");
        data.put("spec", this.hashedRekord);
        try {
            return new JsonCanonicalizer(GsonSupplier.GSON.get().toJson(data)).getEncodedString();
        }
        catch (IOException ioe) {
            throw new RuntimeException("GSON generated invalid json when serializing HashedRekordRequest");
        }
    }

    public HashedRekord getHashedRekord() {
        return this.hashedRekord;
    }

    public String computeUUID() {
        byte[] merkleContent = Bytes.concat((byte[][])new byte[][]{{0}, this.toJsonPayload().getBytes(StandardCharsets.UTF_8)});
        return Hashing.sha256().hashBytes(merkleContent).toString();
    }
}

