/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry.Verification", generator="Immutables")
@Immutable
public final class ImmutableVerification
implements RekorEntry.Verification {
    @Nullable
    private final String signedEntryTimestamp;
    private final RekorEntry.InclusionProof inclusionProof;

    private ImmutableVerification(@Nullable String signedEntryTimestamp, RekorEntry.InclusionProof inclusionProof) {
        this.signedEntryTimestamp = signedEntryTimestamp;
        this.inclusionProof = inclusionProof;
    }

    @Override
    @Nullable
    public String getSignedEntryTimestamp() {
        return this.signedEntryTimestamp;
    }

    @Override
    public RekorEntry.InclusionProof getInclusionProof() {
        return this.inclusionProof;
    }

    public final ImmutableVerification withSignedEntryTimestamp(@Nullable String value) {
        if (Objects.equals(this.signedEntryTimestamp, value)) {
            return this;
        }
        return new ImmutableVerification(value, this.inclusionProof);
    }

    public final ImmutableVerification withInclusionProof(RekorEntry.InclusionProof value) {
        if (this.inclusionProof == value) {
            return this;
        }
        RekorEntry.InclusionProof newValue = Objects.requireNonNull(value, "inclusionProof");
        return new ImmutableVerification(this.signedEntryTimestamp, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerification && this.equalTo(0, (ImmutableVerification)another);
    }

    private boolean equalTo(int synthetic, ImmutableVerification another) {
        return Objects.equals(this.signedEntryTimestamp, another.signedEntryTimestamp) && this.inclusionProof.equals(another.inclusionProof);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.signedEntryTimestamp);
        h += (h << 5) + this.inclusionProof.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Verification").omitNullValues().add("signedEntryTimestamp", (Object)this.signedEntryTimestamp).add("inclusionProof", (Object)this.inclusionProof).toString();
    }

    public static ImmutableVerification copyOf(RekorEntry.Verification instance) {
        if (instance instanceof ImmutableVerification) {
            return (ImmutableVerification)instance;
        }
        return ImmutableVerification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry.Verification", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INCLUSION_PROOF = 1L;
        private long initBits = 1L;
        @Nullable
        private String signedEntryTimestamp;
        @Nullable
        private RekorEntry.InclusionProof inclusionProof;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry.Verification instance) {
            Objects.requireNonNull(instance, "instance");
            String signedEntryTimestampValue = instance.getSignedEntryTimestamp();
            if (signedEntryTimestampValue != null) {
                this.signedEntryTimestamp(signedEntryTimestampValue);
            }
            this.inclusionProof(instance.getInclusionProof());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signedEntryTimestamp(@Nullable String signedEntryTimestamp) {
            this.signedEntryTimestamp = signedEntryTimestamp;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inclusionProof(RekorEntry.InclusionProof inclusionProof) {
            this.inclusionProof = Objects.requireNonNull(inclusionProof, "inclusionProof");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableVerification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVerification(this.signedEntryTimestamp, this.inclusionProof);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("inclusionProof");
            }
            return "Cannot build Verification, some of required attributes are not set " + attributes;
        }
    }
}

