/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import dev.sigstore.KeylessVerificationException;
import dev.sigstore.TrustedRootProvider;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.rekor.client.HashedRekordRequest;
import dev.sigstore.rekor.client.RekorClient;
import dev.sigstore.rekor.client.RekorClientHttp;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.trustroot.TransparencyLog;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.sql.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RekorEntryFetcher {
    private final List<RekorClient> rekorClients;

    public static RekorEntryFetcher sigstoreStaging() throws InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException, InvalidKeyException {
        SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().useStagingInstance();
        return RekorEntryFetcher.fromTrustedRoot(TrustedRootProvider.from(sigstoreTufClientBuilder));
    }

    public static RekorEntryFetcher sigstorePublicGood() throws InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException, InvalidKeyException {
        SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().usePublicGoodInstance();
        return RekorEntryFetcher.fromTrustedRoot(TrustedRootProvider.from(sigstoreTufClientBuilder));
    }

    public static RekorEntryFetcher fromTrustedRoot(Path trustedRoot) throws InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException, InvalidKeyException {
        return RekorEntryFetcher.fromTrustedRoot(TrustedRootProvider.from(trustedRoot));
    }

    public static RekorEntryFetcher fromTrustedRoot(TrustedRootProvider trustedRootProvider) throws InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException, InvalidKeyException {
        SigstoreTrustedRoot trustedRoot = trustedRootProvider.get();
        List<RekorClient> rekorClients = trustedRoot.getTLogs().stream().map(TransparencyLog::getBaseUrl).distinct().map(uri -> RekorClientHttp.builder().setUri((URI)uri).build()).collect(Collectors.toList());
        return new RekorEntryFetcher(rekorClients);
    }

    public RekorEntryFetcher(List<RekorClient> rekorClients) {
        this.rekorClients = rekorClients;
    }

    public RekorEntry getEntryFromRekor(byte[] artifactDigest, X509Certificate leafCert, byte[] signature) throws KeylessVerificationException {
        HashedRekordRequest hashedRekordRequest;
        try {
            hashedRekordRequest = HashedRekordRequest.newHashedRekordRequest(artifactDigest, Certificates.toPemBytes(leafCert), signature);
        }
        catch (IOException e) {
            throw new KeylessVerificationException("Could not convert certificate to PEM when recreating hashrekord", e);
        }
        try {
            for (RekorClient rekorClient : this.rekorClients) {
                Optional<RekorEntry> rekorEntry = rekorClient.getEntry(hashedRekordRequest);
                if (!rekorEntry.isPresent()) continue;
                java.util.Date entryTime = Date.from(rekorEntry.get().getIntegratedTimeInstant());
                try {
                    leafCert.checkValidity(entryTime);
                }
                catch (CertificateExpiredException | CertificateNotYetValidException ex) {
                    continue;
                }
                return rekorEntry.get();
            }
        }
        catch (RekorParseException | IOException e) {
            throw new KeylessVerificationException("Could not retrieve rekor entry", e);
        }
        throw new KeylessVerificationException("No valid rekor entry was not found in any known logs");
    }
}

