/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonSyntaxException;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.client.ImmutableRekorResponse;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public interface RekorResponse {
    public static RekorResponse newRekorResponse(URI entryLocation, String rawResponse) throws RekorParseException {
        Map entryMap;
        Type type = new TypeToken<Map<String, RekorEntry>>(){}.getType();
        try {
            entryMap = (Map)GsonSupplier.GSON.get().fromJson(rawResponse, type);
        }
        catch (JsonSyntaxException | NullPointerException | NumberFormatException | StringIndexOutOfBoundsException ex) {
            throw new RekorParseException("Rekor entry json could not be parsed: " + rawResponse, ex);
        }
        if (entryMap == null) {
            throw new RekorParseException("Expecting a single rekor entry in response but found none");
        }
        if (entryMap.size() != 1) {
            throw new RekorParseException("Expecting a single rekor entry in response but found: " + entryMap.size());
        }
        Map.Entry entry = entryMap.entrySet().iterator().next();
        if (entry == null || entry.getKey() == null || entry.getValue() == null) {
            throw new RekorParseException("Expecting single rekor entry but found an invalid entry: " + rawResponse);
        }
        return ImmutableRekorResponse.builder().entryLocation(entryLocation).raw(rawResponse).uuid((String)entry.getKey()).entry((RekorEntry)entry.getValue()).build();
    }

    public URI getEntryLocation();

    public RekorEntry getEntry();

    public String getUuid();

    public String getRaw();
}

