/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.api.client.util.Lists;
import dev.sigstore.proto.trustroot.v1.TrustedRoot;
import dev.sigstore.trustroot.CertificateAuthority;
import dev.sigstore.trustroot.ImmutableSigstoreTrustedRoot;
import dev.sigstore.trustroot.TransparencyLog;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface SigstoreTrustedRoot {
    public List<CertificateAuthority> getCAs();

    public List<TransparencyLog> getTLogs();

    public List<TransparencyLog> getCTLogs();

    public static SigstoreTrustedRoot from(TrustedRoot proto) throws CertificateException {
        ArrayList cas = Lists.newArrayList();
        for (dev.sigstore.proto.trustroot.v1.CertificateAuthority certAuthority : proto.getCertificateAuthoritiesList()) {
            cas.add(CertificateAuthority.from(certAuthority));
        }
        List tlogs = proto.getTlogsList().stream().map(TransparencyLog::from).collect(Collectors.toList());
        List ctlogs = proto.getCtlogsList().stream().map(TransparencyLog::from).collect(Collectors.toList());
        return ImmutableSigstoreTrustedRoot.builder().cAs(cas).tLogs(tlogs).cTLogs(ctlogs).build();
    }
}

