/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import dev.sigstore.proto.ProtoMutators;
import dev.sigstore.proto.common.v1.TimeRange;
import dev.sigstore.trustroot.ImmutableValidFor;
import java.time.Instant;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ValidFor {
    public abstract Instant getStart();

    public abstract Optional<Instant> getEnd();

    public boolean contains(Instant instant) {
        if (instant.isBefore(this.getStart())) {
            return false;
        }
        if (this.getEnd().isEmpty()) {
            return true;
        }
        return !instant.isAfter(this.getEnd().get());
    }

    public static ValidFor from(TimeRange proto) {
        return ImmutableValidFor.builder().start(ProtoMutators.toInstant(proto.getStart())).end(proto.hasEnd() ? Optional.of(ProtoMutators.toInstant(proto.getEnd())) : Optional.empty()).build();
    }
}

