/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.annotations.VisibleForTesting;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.MetaStore;
import dev.sigstore.tuf.TargetStore;
import dev.sigstore.tuf.model.SignedTufMeta;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class FileSystemTufStore
implements MetaStore,
TargetStore {
    private final Path repoBaseDir;
    private final Path targetsDir;

    @VisibleForTesting
    FileSystemTufStore(Path repoBaseDir, Path targetsDir) {
        this.repoBaseDir = repoBaseDir;
        this.targetsDir = targetsDir;
    }

    public static FileSystemTufStore newFileSystemStore(Path repoBaseDir) throws IOException {
        if (!Files.isDirectory(repoBaseDir, new LinkOption[0])) {
            throw new IllegalArgumentException(repoBaseDir + " must be a file system directory.");
        }
        Path defaultTargetsCache = repoBaseDir.resolve("targets");
        if (!Files.exists(defaultTargetsCache, new LinkOption[0])) {
            Files.createDirectory(defaultTargetsCache, new FileAttribute[0]);
        }
        return FileSystemTufStore.newFileSystemStore(repoBaseDir, defaultTargetsCache);
    }

    public static FileSystemTufStore newFileSystemStore(Path repoBaseDir, Path targetsCache) {
        if (!Files.isDirectory(repoBaseDir, new LinkOption[0])) {
            throw new IllegalArgumentException(repoBaseDir + " must be a file system directory.");
        }
        if (!Files.isDirectory(targetsCache, new LinkOption[0])) {
            throw new IllegalArgumentException(targetsCache + " must be a file system directory.");
        }
        return new FileSystemTufStore(repoBaseDir, targetsCache);
    }

    @Override
    public String getIdentifier() {
        return "Meta: " + this.repoBaseDir.toAbsolutePath() + ", Targets:" + this.targetsDir.toAbsolutePath();
    }

    @Override
    public void writeTarget(String targetName, byte[] targetContents) throws IOException {
        String encoded = URLEncoder.encode(targetName, StandardCharsets.UTF_8);
        Files.write(this.targetsDir.resolve(encoded), targetContents, new OpenOption[0]);
    }

    @Override
    public byte[] readTarget(String targetName) throws IOException {
        String encoded = URLEncoder.encode(targetName, StandardCharsets.UTF_8);
        return Files.readAllBytes(this.targetsDir.resolve(encoded));
    }

    public void writeMeta(String roleName, SignedTufMeta<?> meta) throws IOException {
        this.storeRole(roleName, meta);
    }

    @Override
    public <T extends SignedTufMeta<?>> Optional<T> readMeta(String roleName, Class<T> tClass) throws IOException {
        Path roleFile = this.repoBaseDir.resolve(roleName + ".json");
        if (!roleFile.toFile().exists()) {
            return Optional.empty();
        }
        return Optional.of((SignedTufMeta)GsonSupplier.GSON.get().fromJson(Files.readString(roleFile), tClass));
    }

    <T extends SignedTufMeta<?>> void storeRole(String roleName, T role) throws IOException {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(this.repoBaseDir.resolve(roleName + ".json"), new OpenOption[0]);){
            GsonSupplier.GSON.get().toJson(role, (Appendable)fileWriter);
        }
    }

    @Override
    public void clearMeta(String role) throws IOException {
        Path metaFile = this.repoBaseDir.resolve(role + ".json");
        if (Files.isRegularFile(metaFile, new LinkOption[0])) {
            Files.delete(metaFile);
        }
    }

    public Path getRepoBaseDir() {
        return this.repoBaseDir;
    }

    public Path getTargetsDir() {
        return this.targetsDir;
    }
}

