/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.ImmutableHttpParams;
import dev.sigstore.tuf.Fetcher;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.TufException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class HttpFetcher
implements Fetcher {
    private final URL mirror;

    private HttpFetcher(URL mirror) {
        this.mirror = mirror;
    }

    public static HttpFetcher newFetcher(URL mirror) throws MalformedURLException {
        if (mirror.toString().endsWith("/")) {
            return new HttpFetcher(mirror);
        }
        return new HttpFetcher(new URL(mirror.toExternalForm() + "/"));
    }

    @Override
    public String getSource() {
        return this.mirror.toString();
    }

    @Override
    public byte[] fetchResource(String filename, int maxLength) throws IOException, FileExceedsMaxLengthException {
        GenericUrl fileUrl = new GenericUrl(this.mirror + filename);
        HttpRequest req = HttpClients.newHttpTransport(ImmutableHttpParams.builder().build()).createRequestFactory(request -> request.setParser((ObjectParser)GsonFactory.getDefaultInstance().createJsonObjectParser())).buildGetRequest(fileUrl);
        req.getHeaders().setAccept("application/json; api-version=2.0");
        req.getHeaders().setContentType("application/json");
        req.setThrowExceptionOnExecuteError(false);
        HttpResponse resp = req.execute();
        if (resp.getStatusCode() == 404) {
            return null;
        }
        if (resp.getStatusCode() != 200) {
            throw new TufException(String.format(Locale.ROOT, "Unexpected return from mirror(%s). Status code: %s, status message: %s", this.mirror, resp.getStatusCode(), resp.getStatusMessage()));
        }
        byte[] roleBytes = resp.getContent().readNBytes(maxLength);
        if (roleBytes.length == maxLength && resp.getContent().read() != -1) {
            throw new FileExceedsMaxLengthException(fileUrl.toString(), maxLength);
        }
        return roleBytes;
    }
}

