/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import dev.sigstore.tuf.MetaStore;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.SignedTufMeta;
import dev.sigstore.tuf.model.Snapshot;
import dev.sigstore.tuf.model.Targets;
import dev.sigstore.tuf.model.Timestamp;
import dev.sigstore.tuf.model.TufMeta;
import java.io.IOException;
import java.util.Optional;

public class TrustedMetaStore {
    private final MetaStore metaStore;

    private TrustedMetaStore(MetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public static TrustedMetaStore newTrustedMetaStore(MetaStore metaStore) {
        return new TrustedMetaStore(metaStore);
    }

    public String getIdentifier() {
        return this.metaStore.getIdentifier();
    }

    <T extends SignedTufMeta<? extends TufMeta>> T getMeta(String roleName, Class<T> tClass) throws IOException {
        return (T)((SignedTufMeta)this.metaStore.readMeta(roleName, tClass).orElseThrow(() -> new IllegalStateException("No cached " + roleName + " to load. This error may occur when (1) update hasn't been called or (2) when find should have been used instead of get.")));
    }

    public void setRoot(Root root) throws IOException {
        this.metaStore.writeMeta("root", root);
    }

    public Root getRoot() throws IOException {
        return this.getMeta("root", Root.class);
    }

    public Optional<Root> findRoot() throws IOException {
        return this.metaStore.readMeta("root", Root.class);
    }

    public void setTimestamp(Timestamp timestamp) throws IOException {
        this.metaStore.writeMeta("timestamp", timestamp);
    }

    public Timestamp getTimestamp() throws IOException {
        return this.getMeta("timestamp", Timestamp.class);
    }

    public Optional<Timestamp> findTimestamp() throws IOException {
        return this.metaStore.readMeta("timestamp", Timestamp.class);
    }

    public void setSnapshot(Snapshot snapshot) throws IOException {
        this.metaStore.writeMeta("snapshot", snapshot);
    }

    public Snapshot getSnapshot() throws IOException {
        return this.getMeta("snapshot", Snapshot.class);
    }

    public Optional<Snapshot> findSnapshot() throws IOException {
        return this.metaStore.readMeta("snapshot", Snapshot.class);
    }

    public void setTargets(Targets targets) throws IOException {
        this.metaStore.writeMeta("targets", targets);
    }

    public Targets getTargets() throws IOException {
        return this.getMeta("targets", Targets.class);
    }

    public Optional<Targets> findTargets() throws IOException {
        return this.metaStore.readMeta("targets", Targets.class);
    }

    public void clearMetaDueToKeyRotation() throws IOException {
        this.metaStore.clearMeta("timestamp");
        this.metaStore.clearMeta("snapshot");
    }
}

