/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.encryption;

import dev.sigstore.tuf.encryption.EcdsaVerifier;
import dev.sigstore.tuf.encryption.Ed25519Verifier;
import dev.sigstore.tuf.encryption.RsaPssVerifier;
import dev.sigstore.tuf.encryption.Verifier;
import dev.sigstore.tuf.model.Key;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public class Verifiers {
    public static Verifier newVerifier(Key key) throws IOException, InvalidKeyException {
        PublicKey publicKey = Verifiers.parsePublicKey(key);
        if (key.getKeyType().equals("rsa") && key.getScheme().equals("rsassa-pss-sha256")) {
            return new RsaPssVerifier(publicKey);
        }
        if (Verifiers.isEcdsaKey(key) && key.getScheme().equals("ecdsa-sha2-nistp256")) {
            return new EcdsaVerifier(publicKey);
        }
        if (key.getKeyType().equals("ed25519") && key.getScheme().equals("ed25519")) {
            return new Ed25519Verifier(publicKey);
        }
        throw new InvalidKeyException("Unsupported tuf key type and scheme combination: " + key.getKeyType() + "/" + key.getScheme());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PublicKey parsePublicKey(Key key) throws IOException, InvalidKeyException {
        byte[] keyContents;
        String keyType = key.getKeyType();
        if (keyType.equals("rsa") || Verifiers.isEcdsaKey(key)) {
            try (PEMParser pemParser = new PEMParser((Reader)new StringReader(key.getKeyVal().get("public")));){
                Object keyObj = pemParser.readObject();
                if (keyObj == null) {
                    throw new InvalidKeyException("tuf " + key.getKeyType() + " keys must be a single PEM encoded section");
                }
                if (!(keyObj instanceof SubjectPublicKeyInfo)) throw new InvalidKeyException("Could not parse PEM section into " + keyType + " public key");
                AsymmetricKeyParameter keyInfo = PublicKeyFactory.createKey((SubjectPublicKeyInfo)((SubjectPublicKeyInfo)keyObj));
                if (!keyType.equals("rsa") || !(keyInfo instanceof RSAKeyParameters)) {
                    if (!Verifiers.isEcdsaKey(key)) throw new InvalidKeyException("Could not parse PEM section into " + keyType + " public key");
                    if (!(keyInfo instanceof ECKeyParameters)) throw new InvalidKeyException("Could not parse PEM section into " + keyType + " public key");
                }
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                PublicKey publicKey = converter.getPublicKey((SubjectPublicKeyInfo)keyObj);
                return publicKey;
            }
            catch (DecoderException e) {
                throw new InvalidKeyException("Could not parse PEM section in " + keyType + " public key");
            }
        }
        if (!keyType.equals("ed25519")) throw new InvalidKeyException("Unsupported tuf key type" + key.getKeyType());
        try {
            keyContents = Hex.decode((String)key.getKeyVal().get("public"));
        }
        catch (DecoderException e) {
            throw new InvalidKeyException("Could not parse hex encoded ed25519 public key");
        }
        SubjectPublicKeyInfo params = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), keyContents);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        return converter.getPublicKey(params);
    }

    private static boolean isEcdsaKey(Key key) {
        return key.getKeyType().equals("ecdsa-sha2-nistp256") || key.getKeyType().equals("ecdsa");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @FunctionalInterface
    public static interface Supplier {
        public Verifier newVerifier(Key var1) throws IOException, InvalidKeyException;
    }
}

