/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.plugin;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DEROctetString;

public class FulcioOidHelper {
    private static final String SIGSTORE_OID_ROOT = "1.3.6.1.4.1.57264";
    private static final String FULCIO_OID_ROOT = "1.3.6.1.4.1.57264.1";
    @Deprecated
    private static final String FULCIO_ISSUER_OID = "1.3.6.1.4.1.57264.1.1";
    private static final String FULCIO_ISSUER_V2_OID = "1.3.6.1.4.1.57264.1.8";

    public static String getIssuer(X509Certificate cert) {
        String issuerV2 = FulcioOidHelper.getIssuerV2(cert);
        if (issuerV2 == null) {
            return FulcioOidHelper.getIssuerV1(cert);
        }
        return issuerV2;
    }

    @Deprecated
    public static String getIssuerV1(X509Certificate cert) {
        return FulcioOidHelper.getExtensionValue(cert, FULCIO_ISSUER_OID, true);
    }

    public static String getIssuerV2(X509Certificate cert) {
        return FulcioOidHelper.getExtensionValue(cert, FULCIO_ISSUER_V2_OID, false);
    }

    private static String getExtensionValue(X509Certificate cert, String oid, boolean rawUtf8) {
        byte[] extensionValue = cert.getExtensionValue(oid);
        if (extensionValue == null) {
            return null;
        }
        try {
            ASN1Primitive derObject = ASN1Sequence.fromByteArray((byte[])cert.getExtensionValue(oid));
            if (derObject instanceof DEROctetString) {
                DEROctetString derOctetString = (DEROctetString)derObject;
                if (rawUtf8) {
                    return new String(derOctetString.getOctets(), StandardCharsets.UTF_8);
                }
                derObject = ASN1Sequence.fromByteArray((byte[])derOctetString.getOctets());
                if (derObject instanceof ASN1String) {
                    ASN1String s = (ASN1String)derObject;
                    return s.getString();
                }
            }
            throw new RuntimeException("Could not parse extension " + oid + " in certificate because it was not an octet string");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not parse extension " + oid + " in certificate", ioe);
        }
    }
}

