/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.plugin;

import dev.sigstore.KeylessSigner;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.plugin.FulcioOidHelper;
import dev.sigstore.rekor.client.RekorEntry;
import java.io.File;
import java.security.cert.X509Certificate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.FilesCollector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="sign", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SigstoreSignAttachedMojo
extends AbstractMojo {
    private static final String BUNDLE_EXTENSION = ".sigstore.json";
    @Parameter(property="sigstore.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="false", property="public-staging")
    private boolean publicStaging;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        FilesCollector collector = new FilesCollector(this.project, this.excludes, this.getLog());
        List items = collector.collect();
        this.getLog().info((CharSequence)("Signing " + items.size() + " file" + (items.size() > 1 ? "s" : "") + "."));
        try {
            KeylessSigner signer = this.publicStaging ? KeylessSigner.builder().sigstoreStagingDefaults().build() : KeylessSigner.builder().sigstorePublicDefaults().build();
            X509Certificate prevCert = null;
            for (FilesCollector.Item item : items) {
                File fileToSign = item.getFile();
                this.getLog().info((CharSequence)("Signing " + fileToSign));
                long start = System.currentTimeMillis();
                Bundle bundle = signer.signFile(fileToSign.toPath());
                X509Certificate cert = (X509Certificate)bundle.getCertPath().getCertificates().get(0);
                if (!cert.equals(prevCert)) {
                    prevCert = cert;
                    long durationMinutes = Certificates.validity((X509Certificate)cert, (ChronoUnit)ChronoUnit.MINUTES);
                    this.getLog().info((CharSequence)("  Fulcio certificate (valid for " + durationMinutes + " m) obtained for " + cert.getSubjectAlternativeNames().iterator().next().get(1) + " (by " + FulcioOidHelper.getIssuerV2(cert) + " IdP)"));
                }
                File bundleFile = new File(fileToSign + BUNDLE_EXTENSION);
                FileUtils.fileWrite((File)bundleFile, (String)"UTF-8", (String)bundle.toJson());
                long duration = System.currentTimeMillis() - start;
                this.getLog().info((CharSequence)("  > Rekor entry " + ((RekorEntry)bundle.getEntries().get(0)).getLogIndex() + " obtained in " + duration + " ms, saved to " + bundleFile.getName()));
                this.projectHelper.attachArtifact(this.project, item.getExtension() + BUNDLE_EXTENSION, item.getClassifier(), bundleFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while signing with sigstore", e);
        }
    }
}

