package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.Slf4jLogger;
import dev.snowdrop.buildpack.builder.Nested;
import dev.snowdrop.buildpack.SystemLoggerBuilder;
import dev.snowdrop.buildpack.SystemLoggerFluentImpl;
import java.lang.String;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.Slf4jLoggerBuilder;
import dev.snowdrop.buildpack.SystemLogger;
import java.lang.Deprecated;
import dev.snowdrop.buildpack.Slf4jLoggerFluentImpl;
import dev.snowdrop.buildpack.builder.BaseFluent;
import java.lang.Class;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
public class LogConfigFluentImpl<A extends dev.snowdrop.buildpack.config.LogConfigFluent<A>> extends dev.snowdrop.buildpack.builder.BaseFluent<A> implements dev.snowdrop.buildpack.config.LogConfigFluent<A>{
  public LogConfigFluentImpl() {
  }
  public LogConfigFluentImpl(dev.snowdrop.buildpack.config.LogConfig instance) {
    this.withLogLevel(instance.getLogLevel()); 
    this.withUseTimestamps(instance.getUseTimestamps()); 
    this.withLogger(instance.getLogger()); 
  }
  private java.lang.String logLevel;
  private java.lang.Boolean useTimestamps;
  private dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.Logger,?> logger;
  public java.lang.String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(java.lang.String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public java.lang.Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public java.lang.Boolean getUseTimestamps() {
    return this.useTimestamps;
  }
  public A withUseTimestamps(java.lang.Boolean useTimestamps) {
    this.useTimestamps=useTimestamps; return (A) this;
  }
  public java.lang.Boolean hasUseTimestamps() {
    return this.useTimestamps != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLogger instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.Logger getLogger() {
    return this.logger!=null?this.logger.build():null;
  }
  public dev.snowdrop.buildpack.Logger buildLogger() {
    return this.logger!=null?this.logger.build():null;
  }
  public A withLogger(dev.snowdrop.buildpack.Logger logger) {
    if (logger instanceof dev.snowdrop.buildpack.SystemLogger){ this.logger= new dev.snowdrop.buildpack.SystemLoggerBuilder((dev.snowdrop.buildpack.SystemLogger)logger); _visitables.get("logger").add(this.logger);}
    if (logger instanceof dev.snowdrop.buildpack.Slf4jLogger){ this.logger= new dev.snowdrop.buildpack.Slf4jLoggerBuilder((dev.snowdrop.buildpack.Slf4jLogger)logger); _visitables.get("logger").add(this.logger);}
    return (A) this;
  }
  public java.lang.Boolean hasLogger() {
    return this.logger != null;
  }
  public A withSystemLogger(dev.snowdrop.buildpack.SystemLogger systemLogger) {
    _visitables.get("logger").remove(this.logger);
    if (systemLogger!=null){ this.logger= new dev.snowdrop.buildpack.SystemLoggerBuilder(systemLogger); _visitables.get("logger").add(this.logger);} return (A) this;
  }
  public dev.snowdrop.buildpack.config.LogConfigFluent.SystemLoggerNested<A> withNewSystemLogger() {
    return new dev.snowdrop.buildpack.config.LogConfigFluentImpl.SystemLoggerNestedImpl();
  }
  public dev.snowdrop.buildpack.config.LogConfigFluent.SystemLoggerNested<A> withNewSystemLoggerLike(dev.snowdrop.buildpack.SystemLogger item) {
    return new dev.snowdrop.buildpack.config.LogConfigFluentImpl.SystemLoggerNestedImpl(item);
  }
  public A withNewSystemLogger(boolean ansiColorEnabled) {
    return (A)withSystemLogger(new SystemLogger(ansiColorEnabled));
  }
  public A withSlf4jLogger(dev.snowdrop.buildpack.Slf4jLogger slf4jLogger) {
    _visitables.get("logger").remove(this.logger);
    if (slf4jLogger!=null){ this.logger= new dev.snowdrop.buildpack.Slf4jLoggerBuilder(slf4jLogger); _visitables.get("logger").add(this.logger);} return (A) this;
  }
  public dev.snowdrop.buildpack.config.LogConfigFluent.Slf4jLoggerNested<A> withNewSlf4jLogger() {
    return new dev.snowdrop.buildpack.config.LogConfigFluentImpl.Slf4jLoggerNestedImpl();
  }
  public dev.snowdrop.buildpack.config.LogConfigFluent.Slf4jLoggerNested<A> withNewSlf4jLoggerLike(dev.snowdrop.buildpack.Slf4jLogger item) {
    return new dev.snowdrop.buildpack.config.LogConfigFluentImpl.Slf4jLoggerNestedImpl(item);
  }
  public A withNewSlf4jLogger(java.lang.String name) {
    return (A)withSlf4jLogger(new Slf4jLogger(name));
  }
  public A withNewSlf4jLogger(java.lang.Class c) {
    return (A)withSlf4jLogger(new Slf4jLogger(c));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LogConfigFluentImpl that = (LogConfigFluentImpl) o;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (useTimestamps != null ? !useTimestamps.equals(that.useTimestamps) :that.useTimestamps != null) return false;
    if (logger != null ? !logger.equals(that.logger) :that.logger != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(logLevel,  useTimestamps,  logger,  super.hashCode());
  }
  public class SystemLoggerNestedImpl<N> extends dev.snowdrop.buildpack.SystemLoggerFluentImpl<dev.snowdrop.buildpack.config.LogConfigFluent.SystemLoggerNested<N>> implements dev.snowdrop.buildpack.config.LogConfigFluent.SystemLoggerNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    SystemLoggerNestedImpl(dev.snowdrop.buildpack.SystemLogger item) {
      this.builder = new dev.snowdrop.buildpack.SystemLoggerBuilder(this, item);
    }
    SystemLoggerNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.SystemLoggerBuilder(this);
    }
    dev.snowdrop.buildpack.SystemLoggerBuilder builder;
    public N and() {
      return (N) LogConfigFluentImpl.this.withLogger(builder.build());
    }
    public N endSystemLogger() {
      return and();
    }
    
  }
  public class Slf4jLoggerNestedImpl<N> extends dev.snowdrop.buildpack.Slf4jLoggerFluentImpl<dev.snowdrop.buildpack.config.LogConfigFluent.Slf4jLoggerNested<N>> implements dev.snowdrop.buildpack.config.LogConfigFluent.Slf4jLoggerNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    Slf4jLoggerNestedImpl(dev.snowdrop.buildpack.Slf4jLogger item) {
      this.builder = new dev.snowdrop.buildpack.Slf4jLoggerBuilder(this, item);
    }
    Slf4jLoggerNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.Slf4jLoggerBuilder(this);
    }
    dev.snowdrop.buildpack.Slf4jLoggerBuilder builder;
    public N and() {
      return (N) LogConfigFluentImpl.this.withLogger(builder.build());
    }
    public N endSlf4jLogger() {
      return and();
    }
    
  }
  
}