/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.BuildConfigBuilder;
import dev.snowdrop.buildpack.BuildpackBuild;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.CacheConfig;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.LogConfig;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.docker.Content;
import java.util.ArrayList;
import java.util.List;

public class BuildConfig {
    private static final ImageReference DEFAULT_BUILDER_IMAGE = new ImageReference("paketobuildpacks/builder:base");
    private DockerConfig dockerConfig;
    private CacheConfig buildCacheConfig;
    private CacheConfig launchCacheConfig;
    private CacheConfig kanikoCacheConfig;
    private PlatformConfig platformConfig;
    private LogConfig logConfig;
    private ImageReference builderImage;
    private ImageReference runImage;
    private ImageReference outputImage;
    private List<Content> application;
    private final int exitCode;

    public static BuildConfigBuilder builder() {
        return new BuildConfigBuilder();
    }

    public BuildConfig(DockerConfig dockerConfig, CacheConfig buildCacheConfig, CacheConfig launchCacheConfig, CacheConfig kanikoCacheConfig, PlatformConfig platformConfig, LogConfig logConfig, ImageReference builderImage, ImageReference runImage, ImageReference outputImage, List<Content> application) {
        this.dockerConfig = dockerConfig != null ? dockerConfig : DockerConfig.builder().build();
        this.buildCacheConfig = buildCacheConfig != null ? buildCacheConfig : CacheConfig.builder().build();
        this.launchCacheConfig = launchCacheConfig != null ? launchCacheConfig : CacheConfig.builder().build();
        this.kanikoCacheConfig = kanikoCacheConfig != null ? kanikoCacheConfig : CacheConfig.builder().build();
        this.platformConfig = platformConfig != null ? platformConfig : PlatformConfig.builder().build();
        this.logConfig = logConfig != null ? logConfig : LogConfig.builder().build();
        this.builderImage = builderImage != null ? builderImage : DEFAULT_BUILDER_IMAGE;
        this.runImage = runImage;
        this.outputImage = outputImage;
        ArrayList arrayList = this.application = application != null ? application : new ArrayList();
        if (this.outputImage == null) {
            throw new BuildpackException("Output Image missing and must be specified", new IllegalArgumentException());
        }
        if (this.application.size() == 0) {
            throw new BuildpackException("Application content missing and must be specified", new IllegalArgumentException());
        }
        this.exitCode = new BuildpackBuild(this).build();
    }

    public DockerConfig getDockerConfig() {
        return this.dockerConfig;
    }

    public CacheConfig getBuildCacheConfig() {
        return this.buildCacheConfig;
    }

    public CacheConfig getLaunchCacheConfig() {
        return this.launchCacheConfig;
    }

    public CacheConfig getKanikoCacheConfig() {
        return this.kanikoCacheConfig;
    }

    public PlatformConfig getPlatformConfig() {
        return this.platformConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public ImageReference getBuilderImage() {
        return this.builderImage;
    }

    public ImageReference getRunImage() {
        return this.runImage;
    }

    public ImageReference getOutputImage() {
        return this.outputImage;
    }

    public List<Content> getApplication() {
        return this.application;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

