/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.BuildConfig;
import dev.snowdrop.buildpack.BuildConfigFluent;
import dev.snowdrop.buildpack.BuildConfigFluentImpl;
import dev.snowdrop.buildpack.EditableBuildConfig;
import dev.snowdrop.buildpack.builder.VisitableBuilder;
import java.util.Objects;

public class BuildConfigBuilder
extends BuildConfigFluentImpl<BuildConfigBuilder>
implements VisitableBuilder<BuildConfig, BuildConfigBuilder> {
    BuildConfigFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigBuilder() {
        this(false);
    }

    public BuildConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, BuildConfig instance) {
        this(fluent, instance, false);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, BuildConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDockerConfig(instance.getDockerConfig());
        fluent.withBuildCacheConfig(instance.getBuildCacheConfig());
        fluent.withLaunchCacheConfig(instance.getLaunchCacheConfig());
        fluent.withKanikoCacheConfig(instance.getKanikoCacheConfig());
        fluent.withPlatformConfig(instance.getPlatformConfig());
        fluent.withLogConfig(instance.getLogConfig());
        fluent.withBuilderImage(instance.getBuilderImage());
        fluent.withRunImage(instance.getRunImage());
        fluent.withOutputImage(instance.getOutputImage());
        fluent.withApplication(instance.getApplication());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigBuilder(BuildConfig instance) {
        this(instance, (Boolean)false);
    }

    public BuildConfigBuilder(BuildConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDockerConfig(instance.getDockerConfig());
        this.withBuildCacheConfig(instance.getBuildCacheConfig());
        this.withLaunchCacheConfig(instance.getLaunchCacheConfig());
        this.withKanikoCacheConfig(instance.getKanikoCacheConfig());
        this.withPlatformConfig(instance.getPlatformConfig());
        this.withLogConfig(instance.getLogConfig());
        this.withBuilderImage(instance.getBuilderImage());
        this.withRunImage(instance.getRunImage());
        this.withOutputImage(instance.getOutputImage());
        this.withApplication(instance.getApplication());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableBuildConfig build() {
        EditableBuildConfig buildable = new EditableBuildConfig(this.fluent.getDockerConfig(), this.fluent.getBuildCacheConfig(), this.fluent.getLaunchCacheConfig(), this.fluent.getKanikoCacheConfig(), this.fluent.getPlatformConfig(), this.fluent.getLogConfig(), this.fluent.getBuilderImage(), this.fluent.getRunImage(), this.fluent.getOutputImage(), this.fluent.getApplication());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigBuilder that = (BuildConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

