/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.docker.ImageUtils;
import dev.snowdrop.buildpack.lifecycle.Version;
import dev.snowdrop.buildpack.utils.BuildpackMetadata;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BuilderImage {
    private int DEFAULT_USER_ID = 1000;
    private int DEFAULT_GROUP_ID = 1000;
    private ImageReference image;
    private int userId;
    private int groupId;
    private boolean hasExtensions;
    private String metadataJson;
    private ImageReference runImage;
    private List<String> runImages;
    private List<String> builderSupportedPlatforms;

    public BuilderImage(BuilderImage original, boolean addedExtensions, ImageReference extended) {
        this.userId = original.userId;
        this.groupId = original.groupId;
        this.runImages = original.runImages;
        this.builderSupportedPlatforms = original.builderSupportedPlatforms;
        this.hasExtensions = original.hasExtensions || addedExtensions;
        this.image = extended;
    }

    public BuilderImage(DockerConfig dc, PlatformConfig pc, ImageReference runImage, ImageReference builderImage) {
        String xtnLayers;
        this.image = builderImage;
        ImageUtils.pullImages(dc, builderImage.getReference());
        ImageUtils.ImageInfo ii = ImageUtils.inspectImage(dc.getDockerClient(), builderImage.getReference());
        this.userId = this.DEFAULT_USER_ID;
        this.groupId = this.DEFAULT_GROUP_ID;
        for (String s : ii.env) {
            if (s.startsWith("CNB_USER_ID=")) {
                this.userId = Integer.valueOf(s.substring("CNB_USER_ID=".length()));
            }
            if (!s.startsWith("CNB_GROUP_ID=")) continue;
            this.groupId = Integer.valueOf(s.substring("CNB_GROUP_ID=".length()));
        }
        if (pc.getEnvironment().containsKey("CNB_USER_ID")) {
            this.userId = Integer.valueOf(pc.getEnvironment().get("CNB_USER_ID"));
        }
        if (pc.getEnvironment().containsKey("CNB_GROUP_ID")) {
            this.userId = Integer.valueOf(pc.getEnvironment().get("CNB_GROUP_ID"));
        }
        if ((xtnLayers = ii.labels.get("io.buildpacks.extension.layers")) != null && !xtnLayers.isEmpty()) {
            xtnLayers = xtnLayers.trim();
            xtnLayers.replaceAll("\\\\w", "");
            if (xtnLayers.equals("{}")) {
                xtnLayers = null;
            }
        }
        this.hasExtensions = xtnLayers != null && !xtnLayers.isEmpty();
        this.metadataJson = ii.labels.get("io.buildpacks.builder.metadata");
        this.runImage = runImage;
        this.runImages = null;
        this.builderSupportedPlatforms = BuildpackMetadata.getSupportedPlatformsFromMetadata(this.metadataJson);
    }

    public ImageReference getImage() {
        return this.image;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean hasExtensions() {
        return this.hasExtensions;
    }

    public List<String> getRunImages(Version activePlatformLevel) {
        if (this.runImages == null) {
            this.runImages = new ArrayList<String>();
            if (this.runImage != null) {
                this.runImages.add(this.runImage.getReference());
            } else {
                HashSet<String> runSet = new HashSet<String>();
                if (activePlatformLevel.atLeast("0.12")) {
                    runSet.addAll(BuildpackMetadata.getRunImageFromRunTOML(this.image.getReference()));
                } else {
                    runSet.add(BuildpackMetadata.getRunImageFromMetadataJSON(this.metadataJson));
                }
                this.runImages.addAll(runSet);
            }
        }
        return this.runImages;
    }

    public List<String> getBuilderSupportedPlatforms() {
        return this.builderSupportedPlatforms;
    }
}

