/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.BaseFluent;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.config.PlatformConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PlatformConfigFluentImpl<A extends PlatformConfigFluent<A>>
extends BaseFluent<A>
implements PlatformConfigFluent<A> {
    private String platformLevel;
    private Map<String, String> environment;
    private ImageReference lifecycleImage;
    private Boolean trustBuilder;

    public PlatformConfigFluentImpl() {
    }

    public PlatformConfigFluentImpl(PlatformConfig instance) {
        this.withPlatformLevel(instance.getPlatformLevel());
        this.withLifecycleImage(instance.getLifecycleImage());
        this.withEnvironment(instance.getEnvironment());
        this.withTrustBuilder(instance.getTrustBuilder());
    }

    @Override
    public String getPlatformLevel() {
        return this.platformLevel;
    }

    @Override
    public A withPlatformLevel(String platformLevel) {
        this.platformLevel = platformLevel;
        return (A)this;
    }

    @Override
    public Boolean hasPlatformLevel() {
        return this.platformLevel != null;
    }

    @Override
    public A addToEnvironment(String key, String value) {
        if (this.environment == null && key != null && value != null) {
            this.environment = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.environment.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToEnvironment(Map<String, String> map) {
        if (this.environment == null && map != null) {
            this.environment = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.environment.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvironment(String key) {
        if (this.environment == null) {
            return (A)this;
        }
        if (key != null && this.environment != null) {
            this.environment.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvironment(Map<String, String> map) {
        if (this.environment == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.environment == null) continue;
                this.environment.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public <K, V> A withEnvironment(Map<String, String> environment) {
        this.environment = environment == null ? null : new LinkedHashMap<String, String>(environment);
        return (A)this;
    }

    @Override
    public Boolean hasEnvironment() {
        return this.environment != null;
    }

    @Override
    public ImageReference getLifecycleImage() {
        return this.lifecycleImage;
    }

    @Override
    public A withLifecycleImage(ImageReference lifecycleImage) {
        this.lifecycleImage = lifecycleImage;
        return (A)this;
    }

    @Override
    public Boolean hasLifecycleImage() {
        return this.lifecycleImage != null;
    }

    @Override
    public A withNewLifecycleImage(String reference) {
        return this.withLifecycleImage(new ImageReference(reference));
    }

    @Override
    public Boolean getTrustBuilder() {
        return this.trustBuilder;
    }

    @Override
    public A withTrustBuilder(Boolean trustBuilder) {
        this.trustBuilder = trustBuilder;
        return (A)this;
    }

    @Override
    public Boolean hasTrustBuilder() {
        return this.trustBuilder != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformConfigFluentImpl that = (PlatformConfigFluentImpl)o;
        if (this.platformLevel != null ? !this.platformLevel.equals(that.platformLevel) : that.platformLevel != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (this.lifecycleImage != null ? !this.lifecycleImage.equals(that.lifecycleImage) : that.lifecycleImage != null) {
            return false;
        }
        return !(this.trustBuilder != null ? !this.trustBuilder.equals(that.trustBuilder) : that.trustBuilder != null);
    }

    public int hashCode() {
        return Objects.hash(this.platformLevel, this.environment, this.lifecycleImage, this.trustBuilder, super.hashCode());
    }
}

