/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerUtils {
    private static final Logger log = LoggerFactory.getLogger(ContainerUtils.class);

    public static String createContainer(DockerClient dc, String imageReference, VolumeBind ... volumes) {
        return ContainerUtils.createContainer(dc, imageReference, null, volumes);
    }

    private static Bind createBind(VolumeBind vb) {
        return new Bind(vb.volumeName, new Volume(vb.mountPath));
    }

    public static String createContainer(DockerClient dc, String imageReference, List<String> command, VolumeBind ... volumes) {
        return ContainerUtils.createContainer(dc, imageReference, command, (Integer)0, null, null, null, volumes);
    }

    public static String createContainer(DockerClient dc, String imageReference, List<String> command, Integer runAsId, Map<String, String> env, String securityOpts, String network, List<VolumeBind> volumes) {
        CreateContainerCmd ccc = dc.createContainerCmd(imageReference);
        if (volumes != null) {
            ArrayList<Bind> binds = new ArrayList<Bind>();
            for (VolumeBind vb : volumes) {
                Bind bind = ContainerUtils.createBind(vb);
                binds.add(bind);
            }
            ccc.getHostConfig().withBinds(binds);
        }
        return ContainerUtils.createContainerInternal(dc, imageReference, command, runAsId, env, securityOpts, network, ccc);
    }

    public static String createContainer(DockerClient dc, String imageReference, List<String> command, Integer runAsId, Map<String, String> env, String securityOpts, String network, VolumeBind ... volumes) {
        CreateContainerCmd ccc = dc.createContainerCmd(imageReference);
        if (volumes != null) {
            ArrayList<Bind> binds = new ArrayList<Bind>();
            for (VolumeBind vb : volumes) {
                Bind bind = ContainerUtils.createBind(vb);
                binds.add(bind);
            }
            ccc.getHostConfig().withBinds(binds);
        }
        return ContainerUtils.createContainerInternal(dc, imageReference, command, runAsId, env, securityOpts, network, ccc);
    }

    private static String createContainerInternal(DockerClient dc, String imageReference, List<String> command, Integer runAsId, Map<String, String> env, String securityOpts, String network, CreateContainerCmd ccc) {
        if (runAsId != null) {
            ccc.withUser("" + runAsId);
        }
        if (env != null) {
            ccc.withEnv(env.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList()));
        }
        if (securityOpts != null) {
            ccc.withHostConfig(ccc.getHostConfig().withSecurityOpts(Collections.singletonList(securityOpts)));
        }
        if (command != null) {
            ccc.withCmd(command);
            ccc.withEntrypoint(new String[]{""});
        }
        if (network != null) {
            ccc.withHostConfig(ccc.getHostConfig().withNetworkMode(network));
        }
        CreateContainerResponse ccr = ccc.exec();
        return ccr.getId();
    }

    public static String commitContainer(DockerClient dc, String containerId) {
        return dc.commitCmd(containerId).exec();
    }

    public static void removeContainer(DockerClient dc, String containerId) {
        dc.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
    }

    public static void addContentToContainer(DockerClient dc, String containerId, List<ContainerEntry> entries) {
        ContainerUtils.addContentToContainer(dc, containerId, entries != null ? entries.toArray(new ContainerEntry[entries.size()]) : new ContainerEntry[]{});
    }

    public static void addContentToContainer(DockerClient dc, String containerId, ContainerEntry ... entries) {
        ContainerUtils.addContentToContainer(dc, containerId, "", null, null, entries);
    }

    public static void addContentToContainer(DockerClient dc, String containerId, String pathInContainer, Integer userId, Integer groupId, File content) {
        ContainerUtils.addContentToContainer(dc, containerId, pathInContainer, userId, groupId, new FileContent("", content).getContainerEntries());
    }

    public static void addContentToContainer(DockerClient dc, String containerId, String pathInContainer, Integer userId, Integer groupId, String name, Integer mode, String content) {
        ContainerUtils.addContentToContainer(dc, containerId, pathInContainer, userId, groupId, new StringContent(name, mode, content).getContainerEntries());
    }

    private static void addParents(TarArchiveOutputStream tout, Set<String> seenDirs, int uid, int gid, String path) {
        try {
            String parent;
            boolean unknown;
            if (path.contains("/") && (unknown = seenDirs.add(parent = path.substring(0, path.lastIndexOf("/"))))) {
                ContainerUtils.addParents(tout, seenDirs, uid, gid, parent);
                log.debug("adding " + parent + "/ to tar");
                TarArchiveEntry tae = new TarArchiveEntry(parent + "/");
                tae.setSize(0L);
                tae.setUserId(uid);
                tae.setGroupId(gid);
                tae.setMode(16877);
                tout.putArchiveEntry((ArchiveEntry)tae);
                tout.closeArchiveEntry();
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    public static void addContentToContainer(DockerClient dc, String containerId, String pathInContainer, Integer userId, Integer groupId, List<ContainerEntry> entries) {
        ContainerUtils.addContentToContainer(dc, containerId, pathInContainer, userId, groupId, entries != null ? entries.toArray(new ContainerEntry[entries.size()]) : new ContainerEntry[]{});
    }

    public static void addContentToContainer(final DockerClient dc, final String containerId, String pathInContainer, Integer userId, Integer groupId, final ContainerEntry ... entries) {
        log.debug("Adding to container " + containerId + " pathInContainer " + pathInContainer);
        final HashSet<String> seenDirs = new HashSet<String>();
        seenDirs.add("");
        final String containerPath = !pathInContainer.isEmpty() && pathInContainer.endsWith("/") ? pathInContainer.substring(0, pathInContainer.length() - 1) : pathInContainer;
        final int uid = userId != null ? userId : 0;
        final int gid = groupId != null ? groupId : 0;
        try (final PipedInputStream in = new PipedInputStream(4096);
             final PipedOutputStream out = new PipedOutputStream(in);){
            final AtomicReference writerException = new AtomicReference();
            Runnable writer = new Runnable(){

                @Override
                public void run() {
                    try (TarArchiveOutputStream tout = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(out)));){
                        tout.setLongFileMode(3);
                        for (ContainerEntry ve : entries) {
                            String entryPath = ve.getPath();
                            if (entryPath == null || entryPath.isEmpty()) {
                                throw new IOException("Error path was empty");
                            }
                            if (entryPath.startsWith("/")) {
                                entryPath = entryPath.substring(1);
                            }
                            ContainerUtils.addParents(tout, seenDirs, uid, gid, entryPath);
                            log.debug("adding " + entryPath + " to tar");
                            TarArchiveEntry tae = new TarArchiveEntry(entryPath);
                            tae.setSize(ve.getSize());
                            tae.setUserId(uid);
                            tae.setGroupId(gid);
                            tae.setMode(32768 + ve.getMode());
                            tout.putArchiveEntry((ArchiveEntry)tae);
                            ContainerEntry.DataSupplier cs = ve.getDataSupplier();
                            if (cs == null) {
                                throw new IOException("Error DataSupplier was not provided");
                            }
                            try (InputStream is = ve.getDataSupplier().getData();){
                                if (is == null) {
                                    throw new IOException("Error DataSupplier gave null for getData");
                                }
                                ContainerUtils.copy(is, (OutputStream)tout);
                            }
                            tout.closeArchiveEntry();
                        }
                    }
                    catch (Exception e) {
                        writerException.set(e);
                    }
                }
            };
            log.debug("Copying archive to container at " + containerPath);
            Runnable reader = new Runnable(){

                @Override
                public void run() {
                    CopyArchiveToContainerCmd c = dc.copyArchiveToContainerCmd(containerId).withRemotePath(containerPath).withTarInputStream((InputStream)in);
                    c.exec();
                }
            };
            Thread t1 = new Thread(writer);
            Thread t2 = new Thread(reader);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (InterruptedException ie) {
                throw BuildpackException.launderThrowable(ie);
            }
            Exception wio = (Exception)writerException.get();
            if (wio != null) {
                throw BuildpackException.launderThrowable(wio);
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileFromContainer(DockerClient dc, String id, String path) {
        byte[] byArray;
        block8: {
            CopyArchiveFromContainerCmd copycmd = dc.copyArchiveFromContainerCmd(id, path);
            ByteArrayOutputStream file = new ByteArrayOutputStream();
            InputStream tarStream = copycmd.exec();
            TarArchiveInputStream tarInput = new TarArchiveInputStream(tarStream);
            try {
                TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
                while (tarEntry != null) {
                    ContainerUtils.copy((InputStream)tarInput, file);
                    file.close();
                    tarEntry = tarInput.getNextTarEntry();
                }
                byArray = file.toByteArray();
                if (tarInput == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tarInput != null) {
                        tarInput.close();
                    }
                    throw throwable;
                }
                catch (NotFoundException nfe) {
                    throw BuildpackException.launderThrowable("Unable to locate container '" + id + "'", nfe);
                }
                catch (IOException e) {
                    throw BuildpackException.launderThrowable("Unable to retrieve '" + path + "' from container", e);
                }
            }
            tarInput.close();
        }
        return byArray;
    }

    private static final void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[8192];
        try {
            int length;
            while ((length = in.read(buf)) > 0) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }
}

