/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.snowdrop.buildpack.utils.OperatingSytem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClientUtils {
    private static final Logger log = LoggerFactory.getLogger(DockerClientUtils.class);

    public static DockerClient getDockerClient() {
        return DockerClientUtils.getDockerClient(DockerClientUtils.getDockerHost());
    }

    public static DockerClient getDockerClient(String dockerHost) {
        if (dockerHost == null || dockerHost.isEmpty()) {
            return DockerClientUtils.getDockerClient(DockerClientUtils.getDockerHost());
        }
        log.debug("Using dockerhost " + dockerHost);
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
        return dockerClient;
    }

    public static String getDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost != null && dockerHost.isEmpty()) {
            return dockerHost;
        }
        switch (OperatingSytem.getOperationSystem()) {
            case WIN: {
                return "npipe:////./pipe/docker_engine";
            }
            case LINUX: {
                File dockerSock = new File("/var/run/docker.sock");
                if (dockerSock.exists()) {
                    return "unix:///var/run/docker.sock";
                }
                File podmanSock = new File("/var/run/podman.sock");
                if (podmanSock.exists()) {
                    return "unix:///var/run/podman.sock";
                }
                try {
                    int uid = (Integer)Files.getAttribute(Paths.get("/proc/self", new String[0]), "unix:uid", new LinkOption[0]);
                    File podmanUserSock = new File("/var/run/user/" + uid + "/podman/podman.sock");
                    if (podmanUserSock.exists()) {
                        return "unix:///var/run/user/" + uid + "/podman/podman.sock";
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return "unix:///var/run/docker.sock";
    }
}

