/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.DockerConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static void pullImages(DockerConfig config, String ... imageNames) {
        HashSet<String> imageNameSet = new HashSet<String>(Arrays.asList(imageNames));
        DockerClient dc = config.getDockerClient();
        if (config.getPullPolicy() == DockerConfig.PullPolicy.IF_NOT_PRESENT) {
            List li = (List)dc.listImagesCmd().exec();
            log.debug("Requested Images " + imageNameSet);
            for (Image i : li) {
                if (i.getRepoTags() == null) continue;
                for (String it : i.getRepoTags()) {
                    log.debug("Known Image : " + it);
                    if (!imageNameSet.contains(it)) continue;
                    imageNameSet.remove(it);
                }
            }
            if (imageNameSet.isEmpty()) {
                log.debug("Nothing to pull, all of " + Arrays.asList(imageNames) + " are known");
                return;
            }
        }
        int retryCount = 0;
        HashMap<String, PullImageResultCallback> pircMap = new HashMap<String, PullImageResultCallback>();
        for (String stillNeeded : imageNameSet) {
            log.debug("pulling '" + stillNeeded + "'");
            PullImageResultCallback pirc = new PullImageResultCallback();
            dc.pullImageCmd(stillNeeded).exec((ResultCallback)pirc);
            pircMap.put(stillNeeded, pirc);
        }
        Throwable lastSeen = null;
        boolean allDone = false;
        while (!allDone && retryCount <= config.getPullRetryCount()) {
            allDone = true;
            long thisWait = config.getPullTimeoutSeconds() + retryCount * config.getPullRetryIncreaseSeconds();
            for (Map.Entry entry : pircMap.entrySet()) {
                boolean done = false;
                try {
                    if (entry.getValue() == null) continue;
                    log.debug("waiting on image " + (String)entry.getKey() + " for " + thisWait + " seconds");
                    done = ((PullImageResultCallback)entry.getValue()).awaitCompletion(thisWait, TimeUnit.SECONDS);
                    log.debug("success for image " + (String)entry.getKey());
                }
                catch (InterruptedException ie) {
                    throw BuildpackException.launderThrowable(ie);
                }
                catch (DockerClientException dce) {
                    lastSeen = dce;
                }
                catch (NotFoundException nfe) {
                    lastSeen = nfe;
                }
                if (!done) {
                    String imageName = (String)entry.getKey();
                    PullImageResultCallback newPirc = new PullImageResultCallback();
                    dc.pullImageCmd(imageName).exec((ResultCallback)newPirc);
                    entry.setValue(newPirc);
                    allDone = false;
                    continue;
                }
                entry.setValue(null);
            }
            if (++retryCount > config.getPullRetryCount()) continue;
            if (lastSeen != null) {
                log.debug("Error during pull " + lastSeen.getMessage());
            }
            log.debug("Retrying (" + retryCount + ") for " + pircMap.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toList()));
        }
        if (lastSeen != null && !allDone) {
            throw lastSeen;
        }
    }

    public static ImageInfo inspectImage(DockerClient dc, String imageName) {
        InspectImageResponse iir = dc.inspectImageCmd(imageName).exec();
        ImageInfo ii = new ImageInfo();
        ii.id = iir.getId();
        ii.labels = iir.getConfig().getLabels();
        ii.env = iir.getConfig().getEnv();
        return ii;
    }

    public static class ImageInfo {
        public String id;
        public Map<String, String> labels;
        public String[] env;
    }
}

