/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeUtils {
    private static final Logger log = LoggerFactory.getLogger(VolumeUtils.class);
    static final String mountPrefix = "/workspace";

    public static boolean createVolumeIfRequired(DockerClient dc, String volumeName) {
        if (!VolumeUtils.exists(dc, volumeName)) {
            return VolumeUtils.internalCreateVolume(dc, volumeName);
        }
        return true;
    }

    public static boolean exists(DockerClient dc, String volumeName) {
        try {
            dc.inspectVolumeCmd(volumeName).exec();
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void removeVolume(DockerClient dc, String volumeName) {
        dc.removeVolumeCmd(volumeName).exec();
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String useImage, String pathInVolume, File content) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, mountPrefix, 0, 0, new FileContent(content).getContainerEntries());
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String useImage, String name, Integer mode, String content) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, mountPrefix, 0, 0, new StringContent(name, mode, content).getContainerEntries());
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String useImage, String prefix, int uid, int gid, List<ContainerEntry> entries) {
        if (!prefix.startsWith("/")) {
            prefix = "/" + prefix;
        }
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, mountPrefix + prefix, uid, gid, entries);
    }

    private static boolean internalCreateVolume(DockerClient dc, String volumeName) {
        dc.createVolumeCmd().withName(volumeName).exec();
        return VolumeUtils.exists(dc, volumeName);
    }

    private static boolean internalAddContentToVolume(DockerClient dc, String volumeName, String useImage, String prefix, int uid, int gid, List<ContainerEntry> entries) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, prefix, uid, gid, entries.toArray(new ContainerEntry[entries.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean internalAddContentToVolume(DockerClient dc, String volumeName, String useImage, String prefix, int uid, int gid, ContainerEntry ... entries) {
        List<String> command = Stream.of("").collect(Collectors.toList());
        String dummyId = ContainerUtils.createContainer(dc, useImage, command, new VolumeBind(volumeName, mountPrefix));
        try {
            log.debug("Adding content to volume " + volumeName + " under prefix " + prefix + " using image " + useImage + " with volume bound at " + mountPrefix + " temp container id " + dummyId);
            ContainerUtils.addContentToContainer(dc, dummyId, prefix, (Integer)uid, (Integer)gid, entries);
            boolean bl = true;
            return bl;
        }
        finally {
            if (dummyId != null) {
                ContainerUtils.removeContainer(dc, dummyId);
            }
        }
    }
}

