/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.lifecycle;

import dev.snowdrop.buildpack.BuildConfig;
import dev.snowdrop.buildpack.BuilderImage;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.ImageUtils;
import dev.snowdrop.buildpack.lifecycle.ContainerStatus;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhase;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhaseFactory;
import dev.snowdrop.buildpack.lifecycle.Version;
import dev.snowdrop.buildpack.lifecycle.phases.Analyzer;
import dev.snowdrop.buildpack.lifecycle.phases.Detector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;

public class LifecycleExecutor {
    private static final Logger log = LoggerFactory.getLogger(LifecycleExecutor.class);
    private final BuildConfig config;
    private final LifecyclePhaseFactory factory;
    private final Version activePlatformLevel;
    private final boolean useCreator;

    private boolean useCreator(boolean extensionsPresent, Boolean trustBuilder) {
        if (trustBuilder == null) {
            log.debug("Trusted Builder not requested, extensions are present? " + extensionsPresent);
            return !extensionsPresent;
        }
        if (!trustBuilder.booleanValue()) {
            log.debug("Trusted builder explicitly set to false");
            return false;
        }
        if (extensionsPresent) {
            log.info("request to trust builder ignored, as extensions are present");
            return false;
        }
        log.debug("request to trust builder honored, will use creator");
        return true;
    }

    public LifecycleExecutor(BuildConfig config, BuilderImage originalBuilder, BuilderImage extendedBuilder, String activePlatformLevel) {
        this.config = config;
        this.useCreator = this.useCreator(extendedBuilder.hasExtensions(), config.getPlatformConfig().getTrustBuilder());
        this.activePlatformLevel = new Version(activePlatformLevel);
        this.factory = new LifecyclePhaseFactory(config.getDockerConfig(), config.getBuildCacheConfig(), config.getLaunchCacheConfig(), config.getKanikoCacheConfig(), config.getPlatformConfig(), config.getLogConfig(), config.getOutputImage(), originalBuilder, extendedBuilder, activePlatformLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        try {
            int rc;
            this.factory.createVolumes(this.config.getApplication());
            if (this.useCreator) {
                rc = this.runPhase(this.factory.getCreator());
            } else {
                Analyzer analyzer = (Analyzer)this.factory.getAnalyzer();
                Detector detector = (Detector)this.factory.getDetector();
                if (!(this.activePlatformLevel.lessThan("0.7") ? (rc = this.runPhase(detector)) != 0 || (rc = this.runPhase(analyzer)) != 0 : (rc = this.runPhase(analyzer)) != 0 || (rc = this.runPhase(detector)) != 0)) {
                    boolean extendedRunImage = false;
                    if (this.activePlatformLevel.atLeast("0.10") && this.factory.getBuilderImage().hasExtensions()) {
                        byte[] analyzerToml = detector.getAnalyzedToml();
                        TomlParseResult analyzed = Toml.parse((String)new String(analyzerToml));
                        String newRunImage = analyzed.getString("run-image.reference");
                        if (this.activePlatformLevel.atLeast("0.12")) {
                            Boolean extend = analyzed.getBoolean("run-image.extend");
                            extendedRunImage = extend == null ? false : extend;
                        }
                        ImageUtils.pullImages(this.config.getDockerConfig(), newRunImage);
                        this.factory.getBuilderImage().getRunImages(this.activePlatformLevel).clear();
                        this.factory.getBuilderImage().getRunImages(this.activePlatformLevel).add(newRunImage);
                    }
                    if ((rc = this.runPhase(this.factory.getRestorer())) == 0 && !(!this.activePlatformLevel.atLeast("0.10") || !this.factory.getBuilderImage().hasExtensions() ? (rc = this.runPhase(this.factory.getBuilder())) != 0 : (rc = this.runPhase(this.factory.getBuildImageExtender())) != 0 || extendedRunImage && (rc = this.runPhase(this.factory.getRunImageExtender())) != 0)) {
                        rc = this.runPhase(this.factory.getExporter(extendedRunImage));
                        if (rc != 0) {
                            // empty if block
                        }
                    }
                }
            }
            if (rc == 0) {
                log.info("Buildpack build phases complete, application image is at " + this.config.getOutputImage().getReference());
            }
            int n = rc;
            return n;
        }
        finally {
            this.factory.tidyUp();
        }
    }

    private int runPhase(LifecyclePhase phase) {
        ContainerStatus phaseRC = phase.runPhase(this.config.getLogConfig().getLogger(), this.config.getLogConfig().getUseTimestamps());
        ContainerUtils.removeContainer(this.config.getDockerConfig().getDockerClient(), phaseRC.getContainerId());
        return phaseRC.getRc();
    }
}

