/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.lifecycle.phases;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import dev.snowdrop.buildpack.ContainerLogReader;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.lifecycle.ContainerStatus;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhase;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhaseFactory;
import dev.snowdrop.buildpack.utils.LifecycleArgs;
import org.slf4j.LoggerFactory;

public class Creator
implements LifecyclePhase {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Creator.class);
    final LifecyclePhaseFactory factory;

    public Creator(LifecyclePhaseFactory factory) {
        this.factory = factory;
    }

    @Override
    public ContainerStatus runPhase(Logger logger, boolean useTimestamps) {
        LifecycleArgs args = new LifecycleArgs("/cnb/lifecycle/creator", this.factory.getOutputImage().getReference());
        args.addArg("-uid", "" + this.factory.getBuilderImage().getUserId());
        args.addArg("-gid", "" + this.factory.getBuilderImage().getGroupId());
        args.addArg("-cache-dir", "/cache-dir");
        args.addArg("-app", "/workspace");
        args.addArg("-layers", "/layers");
        args.addArg("-platform", "/platform");
        args.addArg("-run-image", this.factory.getBuilderImage().getRunImages(this.factory.getPlatformLevel()).get(0));
        args.addArg("-log-level", this.factory.getLogConfig().getLogLevel());
        if (this.factory.getPlatformLevel().atLeast("0.9") && this.factory.getDockerConfig().getUseDaemon().booleanValue()) {
            args.addArg("-launch-cache", "/launch-cache-dir");
        }
        if (this.factory.getDockerConfig().getUseDaemon().booleanValue()) {
            args.addArg("-daemon");
        }
        int runAsId = 0;
        String id = this.factory.getContainerForPhase(args.toArray(), runAsId);
        try {
            log.info("Creator container id " + id + " will be run with uid " + runAsId);
            log.debug("- container args " + args);
            log.info("- launching build container");
            this.factory.getDockerConfig().getDockerClient().startContainerCmd(id).exec();
            log.info("- attaching log relay");
            this.factory.getDockerConfig().getDockerClient().logContainerCmd(id).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(useTimestamps)).exec((ResultCallback)new ContainerLogReader(logger));
            int rc = ((WaitContainerResultCallback)this.factory.getDockerConfig().getDockerClient().waitContainerCmd(id).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            log.info("Creator container complete, with exit code " + rc);
            return ContainerStatus.of(rc, id);
        }
        catch (Exception e) {
            if (id != null) {
                log.info("Exception during creator, removing container " + id);
                ContainerUtils.removeContainer(this.factory.getDockerConfig().getDockerClient(), id);
                log.info("remove complete");
            }
            throw e;
        }
    }
}

