/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;

public class BuildpackMetadata {
    public static List<String> getRunImageFromRunTOML(String imageReference) throws BuildpackException {
        ArrayList<String> runImages = new ArrayList<String>();
        byte[] runTomlData = ContainerUtils.getFileFromContainer(null, imageReference, "/cnb/run.toml");
        TomlParseResult analyzed = Toml.parse((String)new String(runTomlData));
        TomlArray ta = analyzed.getArray("images");
        for (int i = 0; i < ta.size(); ++i) {
            runImages.add(ta.getTable(i).getString("image"));
        }
        return runImages;
    }

    public static String getRunImageFromMetadataJSON(String json) throws BuildpackException {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonNode root = om.readTree(json);
            String ri = JsonUtils.getValue(root, "stack/runImage/image");
            if (ri == null) {
                throw new Exception("No runImage specified, and builderImage is missing metadata declaration");
            }
            if (ri.startsWith("index.docker.io/")) {
                ri = ri.substring("index.docker.io/".length());
                ri = "docker.io/" + ri;
            }
            return ri;
        }
        catch (Exception e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    public static List<String> getSupportedPlatformsFromMetadata(String json) throws BuildpackException {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonNode root = om.readTree(json);
            List<String> platforms = JsonUtils.getArray(root, "lifecycle/apis/platform/supported");
            if (platforms == null) {
                throw new Exception("Bad platform metadata in builder image");
            }
            return platforms;
        }
        catch (Exception e) {
            throw BuildpackException.launderThrowable(e);
        }
    }
}

