/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class FilePermissions {
    public Integer getPermissions(File file) {
        try {
            Set<PosixFilePermission> fp = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            int mode = (fp.contains((Object)PosixFilePermission.OWNER_READ) ? 256 : 0) + (fp.contains((Object)PosixFilePermission.OWNER_WRITE) ? 128 : 0) + (fp.contains((Object)PosixFilePermission.OWNER_EXECUTE) ? 64 : 0) + (fp.contains((Object)PosixFilePermission.GROUP_READ) ? 32 : 0) + (fp.contains((Object)PosixFilePermission.GROUP_WRITE) ? 16 : 0) + (fp.contains((Object)PosixFilePermission.GROUP_EXECUTE) ? 8 : 0) + (fp.contains((Object)PosixFilePermission.OTHERS_READ) ? 4 : 0) + (fp.contains((Object)PosixFilePermission.OTHERS_WRITE) ? 2 : 0) + (fp.contains((Object)PosixFilePermission.OTHERS_EXECUTE) ? 1 : 0);
            return mode;
        }
        catch (IOException io) {
            return (file.canRead() ? 256 : 0) + (file.canWrite() ? 128 : 0) + (file.canExecute() ? 64 : 0) + ((file.canRead() ? 32 : 0) + (file.canWrite() ? 16 : 0) + (file.canExecute() ? 8 : 0));
        }
    }
}

