/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.docker.ImageUtils;
import dev.snowdrop.buildpack.utils.JsonUtils;
import java.util.List;

public class LifecycleMetadata {
    private List<String> platformLevels;
    private List<String> buildpackLevels;

    public LifecycleMetadata(DockerConfig dc, ImageReference lifecycleImage) throws BuildpackException {
        ImageUtils.pullImages(dc, lifecycleImage.getReference());
        ImageUtils.ImageInfo ii = ImageUtils.inspectImage(dc.getDockerClient(), lifecycleImage.getReference());
        String metadataJson = ii.labels.get("io.buildpacks.lifecycle.apis");
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonNode root = om.readTree(metadataJson);
            this.platformLevels = JsonUtils.getArray(root, "/platform/supported");
            if (this.platformLevels == null) {
                throw new Exception("Bad platform metadata in lifecycle image");
            }
            this.buildpackLevels = JsonUtils.getArray(root, "/buildpack/supported");
            if (this.buildpackLevels == null) {
                throw new Exception("Bad buildpack metadata in lifecycle image");
            }
        }
        catch (Exception e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    public List<String> getSupportedPlatformLevels() {
        return this.platformLevels;
    }

    public List<String> getSupportedBuildpackLevels() {
        return this.buildpackLevels;
    }
}

