package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import dev.snowdrop.buildpack.docker.StringContentBuilder;
import java.util.function.Predicate;
import dev.snowdrop.buildpack.docker.StreamContentFluentImpl;
import dev.snowdrop.buildpack.builder.BaseFluent;
import dev.snowdrop.buildpack.config.LogConfigBuilder;
import dev.snowdrop.buildpack.config.DockerConfigBuilder;
import java.util.List;
import java.lang.Boolean;
import dev.snowdrop.buildpack.docker.StringContentFluentImpl;
import dev.snowdrop.buildpack.config.CacheConfigBuilder;
import dev.snowdrop.buildpack.docker.StreamContent;
import dev.snowdrop.buildpack.docker.StreamContentBuilder;
import dev.snowdrop.buildpack.docker.Content;
import java.util.Collection;
import java.lang.Object;
import java.io.File;
import dev.snowdrop.buildpack.config.LogConfig;
import dev.snowdrop.buildpack.builder.Nested;
import dev.snowdrop.buildpack.docker.FileContentFluentImpl;
import dev.snowdrop.buildpack.config.LogConfigFluentImpl;
import dev.snowdrop.buildpack.config.PlatformConfig;
import java.lang.Deprecated;
import dev.snowdrop.buildpack.config.PlatformConfigFluentImpl;
import java.util.Iterator;
import dev.snowdrop.buildpack.config.CacheConfig;
import dev.snowdrop.buildpack.config.CacheConfigFluentImpl;
import dev.snowdrop.buildpack.config.PlatformConfigBuilder;
import dev.snowdrop.buildpack.config.DockerConfigFluentImpl;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.FileContent;
import java.lang.Integer;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.docker.FileContentBuilder;
import dev.snowdrop.buildpack.config.DockerConfig;

 /**
  * Generated
  */
public class BuildConfigFluentImpl<A extends dev.snowdrop.buildpack.BuildConfigFluent<A>> extends dev.snowdrop.buildpack.builder.BaseFluent<A> implements dev.snowdrop.buildpack.BuildConfigFluent<A>{
  public BuildConfigFluentImpl() {
  }
  public BuildConfigFluentImpl(dev.snowdrop.buildpack.BuildConfig instance) {
    this.withDockerConfig(instance.getDockerConfig()); 
    this.withBuildCacheConfig(instance.getBuildCacheConfig()); 
    this.withLaunchCacheConfig(instance.getLaunchCacheConfig()); 
    this.withKanikoCacheConfig(instance.getKanikoCacheConfig()); 
    this.withPlatformConfig(instance.getPlatformConfig()); 
    this.withLogConfig(instance.getLogConfig()); 
    this.withBuilderImage(instance.getBuilderImage()); 
    this.withRunImage(instance.getRunImage()); 
    this.withOutputImage(instance.getOutputImage()); 
    this.withApplication(instance.getApplication()); 
  }
  private dev.snowdrop.buildpack.config.DockerConfigBuilder dockerConfig;
  private dev.snowdrop.buildpack.config.CacheConfigBuilder buildCacheConfig;
  private dev.snowdrop.buildpack.config.CacheConfigBuilder launchCacheConfig;
  private dev.snowdrop.buildpack.config.CacheConfigBuilder kanikoCacheConfig;
  private dev.snowdrop.buildpack.config.PlatformConfigBuilder platformConfig;
  private dev.snowdrop.buildpack.config.LogConfigBuilder logConfig;
  private dev.snowdrop.buildpack.config.ImageReference builderImage;
  private dev.snowdrop.buildpack.config.ImageReference runImage;
  private dev.snowdrop.buildpack.config.ImageReference outputImage;
  private java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> application;
  
  /**
   * This method has been deprecated, please use method buildDockerConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.config.DockerConfig getDockerConfig() {
    return this.dockerConfig!=null ?this.dockerConfig.build():null;
  }
  public dev.snowdrop.buildpack.config.DockerConfig buildDockerConfig() {
    return this.dockerConfig!=null ?this.dockerConfig.build():null;
  }
  public A withDockerConfig(dev.snowdrop.buildpack.config.DockerConfig dockerConfig) {
    _visitables.get("dockerConfig").remove(this.dockerConfig);
    if (dockerConfig!=null){ this.dockerConfig= new dev.snowdrop.buildpack.config.DockerConfigBuilder(dockerConfig); _visitables.get("dockerConfig").add(this.dockerConfig);} return (A) this;
  }
  public java.lang.Boolean hasDockerConfig() {
    return this.dockerConfig != null;
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<A> withNewDockerConfig() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.DockerConfigNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<A> withNewDockerConfigLike(dev.snowdrop.buildpack.config.DockerConfig item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.DockerConfigNestedImpl(item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<A> editDockerConfig() {
    return withNewDockerConfigLike(getDockerConfig());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<A> editOrNewDockerConfig() {
    return withNewDockerConfigLike(getDockerConfig() != null ? getDockerConfig(): new dev.snowdrop.buildpack.config.DockerConfigBuilder().build());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<A> editOrNewDockerConfigLike(dev.snowdrop.buildpack.config.DockerConfig item) {
    return withNewDockerConfigLike(getDockerConfig() != null ? getDockerConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBuildCacheConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.config.CacheConfig getBuildCacheConfig() {
    return this.buildCacheConfig!=null ?this.buildCacheConfig.build():null;
  }
  public dev.snowdrop.buildpack.config.CacheConfig buildBuildCacheConfig() {
    return this.buildCacheConfig!=null ?this.buildCacheConfig.build():null;
  }
  public A withBuildCacheConfig(dev.snowdrop.buildpack.config.CacheConfig buildCacheConfig) {
    _visitables.get("buildCacheConfig").remove(this.buildCacheConfig);
    if (buildCacheConfig!=null){ this.buildCacheConfig= new dev.snowdrop.buildpack.config.CacheConfigBuilder(buildCacheConfig); _visitables.get("buildCacheConfig").add(this.buildCacheConfig);} return (A) this;
  }
  public java.lang.Boolean hasBuildCacheConfig() {
    return this.buildCacheConfig != null;
  }
  public A withNewBuildCacheConfig(java.lang.String cacheVolumeName,java.lang.Boolean deleteCacheAfterBuild) {
    return (A)withBuildCacheConfig(new CacheConfig(cacheVolumeName, deleteCacheAfterBuild));
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<A> withNewBuildCacheConfig() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.BuildCacheConfigNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<A> withNewBuildCacheConfigLike(dev.snowdrop.buildpack.config.CacheConfig item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.BuildCacheConfigNestedImpl(item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<A> editBuildCacheConfig() {
    return withNewBuildCacheConfigLike(getBuildCacheConfig());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<A> editOrNewBuildCacheConfig() {
    return withNewBuildCacheConfigLike(getBuildCacheConfig() != null ? getBuildCacheConfig(): new dev.snowdrop.buildpack.config.CacheConfigBuilder().build());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<A> editOrNewBuildCacheConfigLike(dev.snowdrop.buildpack.config.CacheConfig item) {
    return withNewBuildCacheConfigLike(getBuildCacheConfig() != null ? getBuildCacheConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLaunchCacheConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.config.CacheConfig getLaunchCacheConfig() {
    return this.launchCacheConfig!=null ?this.launchCacheConfig.build():null;
  }
  public dev.snowdrop.buildpack.config.CacheConfig buildLaunchCacheConfig() {
    return this.launchCacheConfig!=null ?this.launchCacheConfig.build():null;
  }
  public A withLaunchCacheConfig(dev.snowdrop.buildpack.config.CacheConfig launchCacheConfig) {
    _visitables.get("launchCacheConfig").remove(this.launchCacheConfig);
    if (launchCacheConfig!=null){ this.launchCacheConfig= new dev.snowdrop.buildpack.config.CacheConfigBuilder(launchCacheConfig); _visitables.get("launchCacheConfig").add(this.launchCacheConfig);} return (A) this;
  }
  public java.lang.Boolean hasLaunchCacheConfig() {
    return this.launchCacheConfig != null;
  }
  public A withNewLaunchCacheConfig(java.lang.String cacheVolumeName,java.lang.Boolean deleteCacheAfterBuild) {
    return (A)withLaunchCacheConfig(new CacheConfig(cacheVolumeName, deleteCacheAfterBuild));
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<A> withNewLaunchCacheConfig() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.LaunchCacheConfigNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<A> withNewLaunchCacheConfigLike(dev.snowdrop.buildpack.config.CacheConfig item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.LaunchCacheConfigNestedImpl(item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<A> editLaunchCacheConfig() {
    return withNewLaunchCacheConfigLike(getLaunchCacheConfig());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<A> editOrNewLaunchCacheConfig() {
    return withNewLaunchCacheConfigLike(getLaunchCacheConfig() != null ? getLaunchCacheConfig(): new dev.snowdrop.buildpack.config.CacheConfigBuilder().build());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<A> editOrNewLaunchCacheConfigLike(dev.snowdrop.buildpack.config.CacheConfig item) {
    return withNewLaunchCacheConfigLike(getLaunchCacheConfig() != null ? getLaunchCacheConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKanikoCacheConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.config.CacheConfig getKanikoCacheConfig() {
    return this.kanikoCacheConfig!=null ?this.kanikoCacheConfig.build():null;
  }
  public dev.snowdrop.buildpack.config.CacheConfig buildKanikoCacheConfig() {
    return this.kanikoCacheConfig!=null ?this.kanikoCacheConfig.build():null;
  }
  public A withKanikoCacheConfig(dev.snowdrop.buildpack.config.CacheConfig kanikoCacheConfig) {
    _visitables.get("kanikoCacheConfig").remove(this.kanikoCacheConfig);
    if (kanikoCacheConfig!=null){ this.kanikoCacheConfig= new dev.snowdrop.buildpack.config.CacheConfigBuilder(kanikoCacheConfig); _visitables.get("kanikoCacheConfig").add(this.kanikoCacheConfig);} return (A) this;
  }
  public java.lang.Boolean hasKanikoCacheConfig() {
    return this.kanikoCacheConfig != null;
  }
  public A withNewKanikoCacheConfig(java.lang.String cacheVolumeName,java.lang.Boolean deleteCacheAfterBuild) {
    return (A)withKanikoCacheConfig(new CacheConfig(cacheVolumeName, deleteCacheAfterBuild));
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<A> withNewKanikoCacheConfig() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.KanikoCacheConfigNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<A> withNewKanikoCacheConfigLike(dev.snowdrop.buildpack.config.CacheConfig item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.KanikoCacheConfigNestedImpl(item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<A> editKanikoCacheConfig() {
    return withNewKanikoCacheConfigLike(getKanikoCacheConfig());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<A> editOrNewKanikoCacheConfig() {
    return withNewKanikoCacheConfigLike(getKanikoCacheConfig() != null ? getKanikoCacheConfig(): new dev.snowdrop.buildpack.config.CacheConfigBuilder().build());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<A> editOrNewKanikoCacheConfigLike(dev.snowdrop.buildpack.config.CacheConfig item) {
    return withNewKanikoCacheConfigLike(getKanikoCacheConfig() != null ? getKanikoCacheConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPlatformConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.config.PlatformConfig getPlatformConfig() {
    return this.platformConfig!=null ?this.platformConfig.build():null;
  }
  public dev.snowdrop.buildpack.config.PlatformConfig buildPlatformConfig() {
    return this.platformConfig!=null ?this.platformConfig.build():null;
  }
  public A withPlatformConfig(dev.snowdrop.buildpack.config.PlatformConfig platformConfig) {
    _visitables.get("platformConfig").remove(this.platformConfig);
    if (platformConfig!=null){ this.platformConfig= new dev.snowdrop.buildpack.config.PlatformConfigBuilder(platformConfig); _visitables.get("platformConfig").add(this.platformConfig);} return (A) this;
  }
  public java.lang.Boolean hasPlatformConfig() {
    return this.platformConfig != null;
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<A> withNewPlatformConfig() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.PlatformConfigNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<A> withNewPlatformConfigLike(dev.snowdrop.buildpack.config.PlatformConfig item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.PlatformConfigNestedImpl(item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<A> editPlatformConfig() {
    return withNewPlatformConfigLike(getPlatformConfig());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<A> editOrNewPlatformConfig() {
    return withNewPlatformConfigLike(getPlatformConfig() != null ? getPlatformConfig(): new dev.snowdrop.buildpack.config.PlatformConfigBuilder().build());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<A> editOrNewPlatformConfigLike(dev.snowdrop.buildpack.config.PlatformConfig item) {
    return withNewPlatformConfigLike(getPlatformConfig() != null ? getPlatformConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLogConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.config.LogConfig getLogConfig() {
    return this.logConfig!=null ?this.logConfig.build():null;
  }
  public dev.snowdrop.buildpack.config.LogConfig buildLogConfig() {
    return this.logConfig!=null ?this.logConfig.build():null;
  }
  public A withLogConfig(dev.snowdrop.buildpack.config.LogConfig logConfig) {
    _visitables.get("logConfig").remove(this.logConfig);
    if (logConfig!=null){ this.logConfig= new dev.snowdrop.buildpack.config.LogConfigBuilder(logConfig); _visitables.get("logConfig").add(this.logConfig);} return (A) this;
  }
  public java.lang.Boolean hasLogConfig() {
    return this.logConfig != null;
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<A> withNewLogConfig() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.LogConfigNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<A> withNewLogConfigLike(dev.snowdrop.buildpack.config.LogConfig item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.LogConfigNestedImpl(item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<A> editLogConfig() {
    return withNewLogConfigLike(getLogConfig());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<A> editOrNewLogConfig() {
    return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): new dev.snowdrop.buildpack.config.LogConfigBuilder().build());
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(dev.snowdrop.buildpack.config.LogConfig item) {
    return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): item);
  }
  public dev.snowdrop.buildpack.config.ImageReference getBuilderImage() {
    return this.builderImage;
  }
  public A withBuilderImage(dev.snowdrop.buildpack.config.ImageReference builderImage) {
    this.builderImage=builderImage; return (A) this;
  }
  public java.lang.Boolean hasBuilderImage() {
    return this.builderImage != null;
  }
  public A withNewBuilderImage(java.lang.String s) {
    return (A)withBuilderImage(new ImageReference(s));
  }
  public dev.snowdrop.buildpack.config.ImageReference getRunImage() {
    return this.runImage;
  }
  public A withRunImage(dev.snowdrop.buildpack.config.ImageReference runImage) {
    this.runImage=runImage; return (A) this;
  }
  public java.lang.Boolean hasRunImage() {
    return this.runImage != null;
  }
  public A withNewRunImage(java.lang.String s) {
    return (A)withRunImage(new ImageReference(s));
  }
  public dev.snowdrop.buildpack.config.ImageReference getOutputImage() {
    return this.outputImage;
  }
  public A withOutputImage(dev.snowdrop.buildpack.config.ImageReference outputImage) {
    this.outputImage=outputImage; return (A) this;
  }
  public java.lang.Boolean hasOutputImage() {
    return this.outputImage != null;
  }
  public A withNewOutputImage(java.lang.String s) {
    return (A)withOutputImage(new ImageReference(s));
  }
  public A addToApplication(dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    _visitables.get("application").add(builder);this.application.add(builder); return (A)this;
  }
  public A addToApplication(java.lang.Integer index,dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    _visitables.get("application").add(index, builder);this.application.add(index, builder); return (A)this;
  }
  public A addToApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.Content item) {
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){addToFileContentApplication(index, (dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){addToStreamContentApplication(index, (dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){addToStringContentApplication(index, (dev.snowdrop.buildpack.docker.StringContent)item);}

    return (A)this;
  }
  public A setToApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.Content item) {
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){setToFileContentApplication(index, (dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){setToStreamContentApplication(index, (dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){setToStringContentApplication(index, (dev.snowdrop.buildpack.docker.StringContent)item);}

    return (A)this;
  }
  public A addToApplication(dev.snowdrop.buildpack.docker.Content... items) {
     if (items != null && items.length > 0 && this.application== null) {this.application = new ArrayList<VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.Content item : items) { 
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){addToFileContentApplication((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){addToStreamContentApplication((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){addToStringContentApplication((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("application").add(builder);this.application.add(builder); }
    } return (A)this;
  }
  public A addAllToApplication(java.util.Collection<dev.snowdrop.buildpack.docker.Content> items) {
     if (items != null && items.size() > 0 && this.application== null) {this.application = new ArrayList<VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.Content item : items) { 
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){addToFileContentApplication((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){addToStreamContentApplication((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){addToStringContentApplication((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("application").add(builder);this.application.add(builder); }
    } return (A)this;
  }
  public A removeFromApplication(dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    _visitables.get("application").remove(builder);this.application.remove(builder); return (A)this;
  }
  public A removeFromApplication(dev.snowdrop.buildpack.docker.Content... items) {
    for (dev.snowdrop.buildpack.docker.Content item : items) {if (item instanceof dev.snowdrop.buildpack.docker.FileContent){removeFromFileContentApplication((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){removeFromStreamContentApplication((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){removeFromStringContentApplication((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("application").remove(builder);this.application.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromApplication(java.util.Collection<dev.snowdrop.buildpack.docker.Content> items) {
    for (dev.snowdrop.buildpack.docker.Content item : items) {if (item instanceof dev.snowdrop.buildpack.docker.FileContent){removeFromFileContentApplication((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){removeFromStreamContentApplication((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){removeFromStringContentApplication((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("application").remove(builder);this.application.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildApplication instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<dev.snowdrop.buildpack.docker.Content> getApplication() {
    return build(application);
  }
  public java.util.List<dev.snowdrop.buildpack.docker.Content> buildApplication() {
    return build(application);
  }
  public dev.snowdrop.buildpack.docker.Content buildApplication(java.lang.Integer index) {
    return this.application.get(index).build();
  }
  public dev.snowdrop.buildpack.docker.Content buildFirstApplication() {
    return this.application.get(0).build();
  }
  public dev.snowdrop.buildpack.docker.Content buildLastApplication() {
    return this.application.get(application.size() - 1).build();
  }
  public dev.snowdrop.buildpack.docker.Content buildMatchingApplication(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    for (dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> item: application) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingApplication(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    for (dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> item: application) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApplication(java.util.List<dev.snowdrop.buildpack.docker.Content> application) {
    if (application != null) {this.application = new java.util.ArrayList(); for (dev.snowdrop.buildpack.docker.Content item : application){this.addToApplication(item);}} else { this.application = null;} return (A) this;
  }
  public A withApplication(dev.snowdrop.buildpack.docker.Content... application) {
    if (this.application != null) {this.application.clear();}
    if (application != null) {for (dev.snowdrop.buildpack.docker.Content item :application){ this.addToApplication(item);}} return (A) this;
  }
  public java.lang.Boolean hasApplication() {
    return application != null && !application.isEmpty();
  }
  public A addToFileContentApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("application").add(index >= 0 ? index : _visitables.get("application").size(), builder);this.application.add(index >= 0 ? index : application.size(), builder); return (A)this;
  }
  public A setToFileContentApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);
    if (index < 0 || index >= _visitables.get("application").size()) { _visitables.get("application").add(builder); } else { _visitables.get("application").set(index, builder);}
    if (index < 0 || index >= application.size()) { application.add(builder); } else { application.set(index, builder);}
     return (A)this;
  }
  public A addToFileContentApplication(dev.snowdrop.buildpack.docker.FileContent... items) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("application").add(builder);this.application.add(builder);} return (A)this;
  }
  public A addAllToFileContentApplication(java.util.Collection<dev.snowdrop.buildpack.docker.FileContent> items) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("application").add(builder);this.application.add(builder);} return (A)this;
  }
  public A removeFromFileContentApplication(dev.snowdrop.buildpack.docker.FileContent... items) {
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("application").remove(builder);if (this.application != null) {this.application.remove(builder);}} return (A)this;
  }
  public A removeAllFromFileContentApplication(java.util.Collection<dev.snowdrop.buildpack.docker.FileContent> items) {
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("application").remove(builder);if (this.application != null) {this.application.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFileContentApplication(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    if (application == null) return (A) this;
    final Iterator<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> each = application.iterator();
    final List visitables = _visitables.get("application");
    while (each.hasNext()) {
      dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.FileContentApplicationNested<A> addNewFileContentApplication() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.FileContentApplicationNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.FileContentApplicationNested<A> addNewFileContentApplicationLike(dev.snowdrop.buildpack.docker.FileContent item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.FileContentApplicationNestedImpl(-1, item);
  }
  public A addNewFileContentApplication(java.io.File file) {
    return (A)addToFileContentApplication(new FileContent(file));
  }
  public A addNewFileContentApplication(java.lang.String prefix,java.io.File file) {
    return (A)addToFileContentApplication(new FileContent(prefix, file));
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.FileContentApplicationNested<A> setNewFileContentApplicationLike(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.FileContentApplicationNestedImpl(index, item);
  }
  public A addToStreamContentApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("application").add(index >= 0 ? index : _visitables.get("application").size(), builder);this.application.add(index >= 0 ? index : application.size(), builder); return (A)this;
  }
  public A setToStreamContentApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);
    if (index < 0 || index >= _visitables.get("application").size()) { _visitables.get("application").add(builder); } else { _visitables.get("application").set(index, builder);}
    if (index < 0 || index >= application.size()) { application.add(builder); } else { application.set(index, builder);}
     return (A)this;
  }
  public A addToStreamContentApplication(dev.snowdrop.buildpack.docker.StreamContent... items) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("application").add(builder);this.application.add(builder);} return (A)this;
  }
  public A addAllToStreamContentApplication(java.util.Collection<dev.snowdrop.buildpack.docker.StreamContent> items) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("application").add(builder);this.application.add(builder);} return (A)this;
  }
  public A removeFromStreamContentApplication(dev.snowdrop.buildpack.docker.StreamContent... items) {
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("application").remove(builder);if (this.application != null) {this.application.remove(builder);}} return (A)this;
  }
  public A removeAllFromStreamContentApplication(java.util.Collection<dev.snowdrop.buildpack.docker.StreamContent> items) {
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("application").remove(builder);if (this.application != null) {this.application.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStreamContentApplication(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    if (application == null) return (A) this;
    final Iterator<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> each = application.iterator();
    final List visitables = _visitables.get("application");
    while (each.hasNext()) {
      dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.StreamContentApplicationNested<A> addNewStreamContentApplication() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.StreamContentApplicationNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.StreamContentApplicationNested<A> addNewStreamContentApplicationLike(dev.snowdrop.buildpack.docker.StreamContent item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.StreamContentApplicationNestedImpl(-1, item);
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.StreamContentApplicationNested<A> setNewStreamContentApplicationLike(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.StreamContentApplicationNestedImpl(index, item);
  }
  public A addToStringContentApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("application").add(index >= 0 ? index : _visitables.get("application").size(), builder);this.application.add(index >= 0 ? index : application.size(), builder); return (A)this;
  }
  public A setToStringContentApplication(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);
    if (index < 0 || index >= _visitables.get("application").size()) { _visitables.get("application").add(builder); } else { _visitables.get("application").set(index, builder);}
    if (index < 0 || index >= application.size()) { application.add(builder); } else { application.set(index, builder);}
     return (A)this;
  }
  public A addToStringContentApplication(dev.snowdrop.buildpack.docker.StringContent... items) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("application").add(builder);this.application.add(builder);} return (A)this;
  }
  public A addAllToStringContentApplication(java.util.Collection<dev.snowdrop.buildpack.docker.StringContent> items) {
    if (this.application == null) {this.application = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("application").add(builder);this.application.add(builder);} return (A)this;
  }
  public A removeFromStringContentApplication(dev.snowdrop.buildpack.docker.StringContent... items) {
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("application").remove(builder);if (this.application != null) {this.application.remove(builder);}} return (A)this;
  }
  public A removeAllFromStringContentApplication(java.util.Collection<dev.snowdrop.buildpack.docker.StringContent> items) {
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("application").remove(builder);if (this.application != null) {this.application.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStringContentApplication(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    if (application == null) return (A) this;
    final Iterator<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> each = application.iterator();
    final List visitables = _visitables.get("application");
    while (each.hasNext()) {
      dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.StringContentApplicationNested<A> addNewStringContentApplication() {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.StringContentApplicationNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.StringContentApplicationNested<A> addNewStringContentApplicationLike(dev.snowdrop.buildpack.docker.StringContent item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.StringContentApplicationNestedImpl(-1, item);
  }
  public A addNewStringContentApplication(java.lang.String path,java.lang.Integer mode,java.lang.String content) {
    return (A)addToStringContentApplication(new StringContent(path, mode, content));
  }
  public dev.snowdrop.buildpack.BuildConfigFluent.StringContentApplicationNested<A> setNewStringContentApplicationLike(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
    return new dev.snowdrop.buildpack.BuildConfigFluentImpl.StringContentApplicationNestedImpl(index, item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildConfigFluentImpl that = (BuildConfigFluentImpl) o;
    if (dockerConfig != null ? !dockerConfig.equals(that.dockerConfig) :that.dockerConfig != null) return false;
    if (buildCacheConfig != null ? !buildCacheConfig.equals(that.buildCacheConfig) :that.buildCacheConfig != null) return false;
    if (launchCacheConfig != null ? !launchCacheConfig.equals(that.launchCacheConfig) :that.launchCacheConfig != null) return false;
    if (kanikoCacheConfig != null ? !kanikoCacheConfig.equals(that.kanikoCacheConfig) :that.kanikoCacheConfig != null) return false;
    if (platformConfig != null ? !platformConfig.equals(that.platformConfig) :that.platformConfig != null) return false;
    if (logConfig != null ? !logConfig.equals(that.logConfig) :that.logConfig != null) return false;
    if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
    if (runImage != null ? !runImage.equals(that.runImage) :that.runImage != null) return false;
    if (outputImage != null ? !outputImage.equals(that.outputImage) :that.outputImage != null) return false;
    if (application != null ? !application.equals(that.application) :that.application != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dockerConfig,  buildCacheConfig,  launchCacheConfig,  kanikoCacheConfig,  platformConfig,  logConfig,  builderImage,  runImage,  outputImage,  application,  super.hashCode());
  }
  public class DockerConfigNestedImpl<N> extends dev.snowdrop.buildpack.config.DockerConfigFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.DockerConfigNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    DockerConfigNestedImpl(dev.snowdrop.buildpack.config.DockerConfig item) {
      this.builder = new dev.snowdrop.buildpack.config.DockerConfigBuilder(this, item);
    }
    DockerConfigNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.config.DockerConfigBuilder(this);
    }
    dev.snowdrop.buildpack.config.DockerConfigBuilder builder;
    public N and() {
      return (N) BuildConfigFluentImpl.this.withDockerConfig(builder.build());
    }
    public N endDockerConfig() {
      return and();
    }
    
  }
  public class BuildCacheConfigNestedImpl<N> extends dev.snowdrop.buildpack.config.CacheConfigFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.BuildCacheConfigNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    BuildCacheConfigNestedImpl(dev.snowdrop.buildpack.config.CacheConfig item) {
      this.builder = new dev.snowdrop.buildpack.config.CacheConfigBuilder(this, item);
    }
    BuildCacheConfigNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.config.CacheConfigBuilder(this);
    }
    dev.snowdrop.buildpack.config.CacheConfigBuilder builder;
    public N and() {
      return (N) BuildConfigFluentImpl.this.withBuildCacheConfig(builder.build());
    }
    public N endBuildCacheConfig() {
      return and();
    }
    
  }
  public class LaunchCacheConfigNestedImpl<N> extends dev.snowdrop.buildpack.config.CacheConfigFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.LaunchCacheConfigNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    LaunchCacheConfigNestedImpl(dev.snowdrop.buildpack.config.CacheConfig item) {
      this.builder = new dev.snowdrop.buildpack.config.CacheConfigBuilder(this, item);
    }
    LaunchCacheConfigNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.config.CacheConfigBuilder(this);
    }
    dev.snowdrop.buildpack.config.CacheConfigBuilder builder;
    public N and() {
      return (N) BuildConfigFluentImpl.this.withLaunchCacheConfig(builder.build());
    }
    public N endLaunchCacheConfig() {
      return and();
    }
    
  }
  public class KanikoCacheConfigNestedImpl<N> extends dev.snowdrop.buildpack.config.CacheConfigFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.KanikoCacheConfigNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    KanikoCacheConfigNestedImpl(dev.snowdrop.buildpack.config.CacheConfig item) {
      this.builder = new dev.snowdrop.buildpack.config.CacheConfigBuilder(this, item);
    }
    KanikoCacheConfigNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.config.CacheConfigBuilder(this);
    }
    dev.snowdrop.buildpack.config.CacheConfigBuilder builder;
    public N and() {
      return (N) BuildConfigFluentImpl.this.withKanikoCacheConfig(builder.build());
    }
    public N endKanikoCacheConfig() {
      return and();
    }
    
  }
  public class PlatformConfigNestedImpl<N> extends dev.snowdrop.buildpack.config.PlatformConfigFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.PlatformConfigNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    PlatformConfigNestedImpl(dev.snowdrop.buildpack.config.PlatformConfig item) {
      this.builder = new dev.snowdrop.buildpack.config.PlatformConfigBuilder(this, item);
    }
    PlatformConfigNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.config.PlatformConfigBuilder(this);
    }
    dev.snowdrop.buildpack.config.PlatformConfigBuilder builder;
    public N and() {
      return (N) BuildConfigFluentImpl.this.withPlatformConfig(builder.build());
    }
    public N endPlatformConfig() {
      return and();
    }
    
  }
  public class LogConfigNestedImpl<N> extends dev.snowdrop.buildpack.config.LogConfigFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.LogConfigNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    LogConfigNestedImpl(dev.snowdrop.buildpack.config.LogConfig item) {
      this.builder = new dev.snowdrop.buildpack.config.LogConfigBuilder(this, item);
    }
    LogConfigNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.config.LogConfigBuilder(this);
    }
    dev.snowdrop.buildpack.config.LogConfigBuilder builder;
    public N and() {
      return (N) BuildConfigFluentImpl.this.withLogConfig(builder.build());
    }
    public N endLogConfig() {
      return and();
    }
    
  }
  public class FileContentApplicationNestedImpl<N> extends dev.snowdrop.buildpack.docker.FileContentFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.FileContentApplicationNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.FileContentApplicationNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    FileContentApplicationNestedImpl(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
      this.index = index;
      this.builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(this, item);
    }
    FileContentApplicationNestedImpl() {
      this.index = -1;
      this.builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(this);
    }
    dev.snowdrop.buildpack.docker.FileContentBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildConfigFluentImpl.this.setToApplication(index,builder.build());
    }
    public N endFileContentApplication() {
      return and();
    }
    
  }
  public class StreamContentApplicationNestedImpl<N> extends dev.snowdrop.buildpack.docker.StreamContentFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.StreamContentApplicationNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.StreamContentApplicationNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    StreamContentApplicationNestedImpl(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
      this.index = index;
      this.builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(this, item);
    }
    StreamContentApplicationNestedImpl() {
      this.index = -1;
      this.builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(this);
    }
    dev.snowdrop.buildpack.docker.StreamContentBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildConfigFluentImpl.this.setToApplication(index,builder.build());
    }
    public N endStreamContentApplication() {
      return and();
    }
    
  }
  public class StringContentApplicationNestedImpl<N> extends dev.snowdrop.buildpack.docker.StringContentFluentImpl<dev.snowdrop.buildpack.BuildConfigFluent.StringContentApplicationNested<N>> implements dev.snowdrop.buildpack.BuildConfigFluent.StringContentApplicationNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    StringContentApplicationNestedImpl(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
      this.index = index;
      this.builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(this, item);
    }
    StringContentApplicationNestedImpl() {
      this.index = -1;
      this.builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(this);
    }
    dev.snowdrop.buildpack.docker.StringContentBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildConfigFluentImpl.this.setToApplication(index,builder.build());
    }
    public N endStringContentApplication() {
      return and();
    }
    
  }
  
}