/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.BuildConfig;
import dev.snowdrop.buildpack.BuilderImage;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.docker.BuildContainerUtils;
import dev.snowdrop.buildpack.docker.ImageUtils;
import dev.snowdrop.buildpack.lifecycle.LifecycleExecutor;
import dev.snowdrop.buildpack.lifecycle.Version;
import dev.snowdrop.buildpack.utils.LifecycleMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildpackBuild {
    private static final Logger log = LoggerFactory.getLogger(BuildpackBuild.class);
    private final List<String> supportedPlatformLevels = Stream.of("0.12", "0.11", "0.10", "0.9", "0.8", "0.7", "0.6", "0.5", "0.4").collect(Collectors.toCollection(ArrayList::new));
    public final String DEFAULT_PLATFORM_LEVEL = this.supportedPlatformLevels.get(0);
    BuildConfig config;

    public BuildpackBuild(BuildConfig config) {
        this.config = config;
    }

    private String selectPlatformLevel(DockerConfig dc, PlatformConfig pc, BuilderImage builder) {
        List<String> platformsToConsider;
        if (pc.getLifecycleImage() == null) {
            platformsToConsider = builder.getBuilderSupportedPlatforms();
            log.debug("Considering platforms " + platformsToConsider + " from builder image");
        } else {
            LifecycleMetadata lm = new LifecycleMetadata(dc, pc.getLifecycleImage());
            platformsToConsider = lm.getSupportedPlatformLevels();
            log.debug("Considering platforms " + platformsToConsider + " from lifecycle image");
        }
        ArrayList<String> platformsToTest = new ArrayList<String>(this.supportedPlatformLevels);
        if (pc.getPlatformLevel() != null && this.supportedPlatformLevels.contains(pc.getPlatformLevel())) {
            platformsToTest.clear();
            platformsToTest.add(pc.getPlatformLevel());
        }
        for (String platform : platformsToTest) {
            if (!platformsToConsider.contains(platform)) continue;
            return platform;
        }
        if (pc.getLifecycleImage() != null) {
            throw new BuildpackException("Unable to determine compatible platform for supplied lifecycle image", new IllegalStateException());
        }
        throw new BuildpackException("Unable to determine compatible platform for builder lifecycle image", new IllegalStateException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int build() {
        log.info("Buildpack build requested with config: \n - builder " + this.config.getBuilderImage().getCanonicalReference() + "\n - output " + this.config.getOutputImage().getReference() + "\n - logLevel " + this.config.getLogConfig().getLogLevel() + "\n - dockerHost " + this.config.getDockerConfig().getDockerHost() + "\n - dockerSocket " + this.config.getDockerConfig().getDockerSocket() + "\n - useDaemon " + this.config.getDockerConfig().getUseDaemon());
        log.info("Pulling Builder image");
        BuilderImage builder = new BuilderImage(this.config.getDockerConfig(), this.config.getPlatformConfig(), this.config.getRunImage(), this.config.getBuilderImage());
        String activePlatformLevel = this.selectPlatformLevel(this.config.getDockerConfig(), this.config.getPlatformConfig(), builder);
        ImageReference[] runImages = builder.getRunImages(new Version(activePlatformLevel));
        if (this.config.getDockerConfig().getUseDaemon().booleanValue()) {
            log.info("Pulling Run Image(s) (requesting architecture [" + builder.getImagePlatform() + "])");
            ImageUtils.pullImages(this.config.getDockerConfig(), builder.getImagePlatform(), runImages);
        }
        log.debug("Creating Ephemeral Builder Image...");
        BuilderImage extendedBuilder = BuildContainerUtils.createBuildImage(this.config.getDockerConfig().getDockerClient(), this.config.getPlatformConfig(), builder, null, null, null);
        try {
            log.info("Initiating buildpack build with derived configuration: \n - ephemeralBuilder " + extendedBuilder.getImage().getCanonicalReference() + "\n - activePlatformLevel " + activePlatformLevel + "\n - build uid:gid " + extendedBuilder.getUserId() + ":" + extendedBuilder.getGroupId() + "\n - withExtensions " + extendedBuilder.hasExtensions());
            LifecycleExecutor le = new LifecycleExecutor(this.config, builder, extendedBuilder, activePlatformLevel);
            int n = le.execute();
            return n;
        }
        finally {
            this.config.getDockerConfig().getDockerClient().removeImageCmd(extendedBuilder.getImage().getCanonicalReference()).exec();
        }
    }
}

