/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageReference {
    String LEGACY_HOST = "index.docker.io";
    String DEFAULT_HOST = "docker.io";
    String DEFAULT_TAG = "latest";
    String regx = "^((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)+)?)(?::([\\w][\\w.-]{0,127}))?(?:@([A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:]\\p{XDigit}{32,}))?$";
    Pattern p = Pattern.compile(this.regx);
    private final String hostname;
    private final boolean hostPresent;
    private final String port;
    private final boolean portPresent;
    private final String repository;
    private final boolean repositoryPresent;
    private final String tag;
    private final boolean tagPresent;
    private final String digest;
    private final boolean digestPresent;
    private final String reference;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageReference(String s) {
        if (s == null) {
            throw new IllegalStateException("ImageReference cannot be built from null");
        }
        this.reference = s;
        Matcher m = this.p.matcher(s);
        if (!m.find()) throw new IllegalStateException("Bad imageref " + s);
        String hostportrepo = this.useHost(m.group(1));
        if (!hostportrepo.contains(":") && !hostportrepo.contains("/")) {
            this.hostname = this.DEFAULT_HOST;
            this.hostPresent = false;
            this.port = null;
            this.portPresent = false;
            this.repository = hostportrepo;
            this.repositoryPresent = true;
        } else if (!hostportrepo.contains(":") && hostportrepo.contains("/")) {
            this.port = null;
            this.portPresent = false;
            String firstpart = hostportrepo.substring(0, hostportrepo.indexOf("/"));
            if (firstpart.startsWith("localhost") || firstpart.contains(".")) {
                this.hostname = this.useHost(firstpart);
                this.hostPresent = firstpart != null;
                this.repository = hostportrepo.substring(firstpart.length() + 1);
            } else {
                this.hostname = this.DEFAULT_HOST;
                this.hostPresent = false;
                this.repository = hostportrepo;
            }
            this.repositoryPresent = true;
        } else {
            if (!hostportrepo.contains(":") || !hostportrepo.contains("/")) throw new IllegalStateException("Bad imageref " + s);
            this.hostname = this.useHost(hostportrepo.substring(0, hostportrepo.indexOf(":")));
            this.hostPresent = hostportrepo.substring(0, hostportrepo.indexOf(":")) != null;
            this.port = hostportrepo.substring(hostportrepo.indexOf(":") + 1, hostportrepo.indexOf("/"));
            this.portPresent = this.port != null;
            this.repository = hostportrepo.substring(hostportrepo.indexOf("/") + 1, hostportrepo.length());
            this.repositoryPresent = true;
        }
        this.digest = m.group(3);
        this.digestPresent = m.group(3) != null;
        this.tag = this.useTag(m.group(2), this.digestPresent);
        this.tagPresent = m.group(2) != null;
    }

    private String useHost(String host) {
        if (host == null || host.equals(this.LEGACY_HOST)) {
            return this.DEFAULT_HOST;
        }
        return host;
    }

    private String useTag(String tag, boolean digestPresent) {
        if (tag == null && !digestPresent) {
            return this.DEFAULT_TAG;
        }
        return tag;
    }

    public int hashCode() {
        String ref = this.getCanonicalReference();
        int prime = 31;
        int result = 1;
        result = 31 * result + (ref == null ? 0 : ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageReference other = (ImageReference)obj;
        String thisRef = this.getCanonicalReference();
        String otherRef = other.getCanonicalReference();
        return !(thisRef == null ? otherRef != null : !thisRef.equals(otherRef));
    }

    public String toString() {
        return this.getCanonicalReference();
    }

    public String getReference() {
        return this.reference;
    }

    public String getReferenceWithLatest() {
        if (!this.tagPresent() && !this.digestPresent()) {
            return this.reference + ":latest";
        }
        return this.reference;
    }

    public String getCanonicalReference() {
        return this.hostname + (this.port != null ? ":" + this.port : "") + "/" + this.repository + (this.tag != null ? ":" + this.tag : "") + (this.digest != null ? "@" + this.digest : "");
    }

    public String getHost() {
        return this.hostname;
    }

    public boolean hostPresent() {
        return this.hostPresent;
    }

    public String getPort() {
        return this.port;
    }

    public boolean portPresent() {
        return this.portPresent;
    }

    public String getRepo() {
        return this.repository;
    }

    public boolean repoPresent() {
        return this.repositoryPresent;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean tagPresent() {
        return this.tagPresent;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean digestPresent() {
        return this.digestPresent;
    }
}

