/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static void pullImages(DockerConfig config, ImageReference ... images) {
        ImageUtils.pullImages(config, null, images);
    }

    public static void pullImages(DockerConfig config, String platform, ImageReference ... images) {
        if (config.getPullPolicy().equals((Object)DockerConfig.PullPolicy.NEVER)) {
            log.debug("Image pull skipped due to policy NEVER");
            return;
        }
        Set imageNameSet = Stream.of(images).collect(Collectors.toCollection(HashSet::new));
        DockerClient dc = config.getDockerClient();
        if (config.getPullPolicy().equals((Object)DockerConfig.PullPolicy.IF_NOT_PRESENT)) {
            List li = (List)dc.listImagesCmd().exec();
            log.debug("Requested Images " + imageNameSet);
            for (Image i2 : li) {
                if (i2.getRepoTags() == null) continue;
                for (String it : i2.getRepoTags()) {
                    ImageReference imageReference = new ImageReference(it);
                    log.debug("IF_NOT_PRESENT evaluating known image : " + imageReference.getCanonicalReference() + " (" + imageReference.getReference() + ")");
                    if (!imageReference.digestPresent() && "latest".equals(imageReference.getTag())) {
                        if (!imageNameSet.contains(imageReference)) continue;
                        log.debug("Image " + imageReference + " Already Known, will be repulled as image using :latest tag");
                        continue;
                    }
                    if (!imageNameSet.contains(imageReference)) continue;
                    log.debug("Image " + imageReference + " Already Known, will not repull image");
                    imageNameSet.remove(imageReference);
                }
            }
            if (imageNameSet.isEmpty()) {
                log.debug("Nothing to pull, all of " + Arrays.asList(images) + " are known");
                return;
            }
        }
        int retryCount = 0;
        HashMap<String, PullImageResultCallback> pircMap = new HashMap<String, PullImageResultCallback>();
        for (ImageReference stillNeeded : imageNameSet) {
            log.debug("pulling '" + stillNeeded.getReferenceWithLatest() + "' " + (platform == null ? "" : " for platform " + platform));
            PullImageResultCallback pirc = new PullImageResultCallback();
            if (platform != null) {
                dc.pullImageCmd(stillNeeded.getReferenceWithLatest()).withPlatform(platform).exec((ResultCallback)pirc);
            } else {
                dc.pullImageCmd(stillNeeded.getReferenceWithLatest()).exec((ResultCallback)pirc);
            }
            pircMap.put(stillNeeded.getReferenceWithLatest(), pirc);
        }
        Throwable lastSeen = null;
        boolean allDone = false;
        while (!allDone && retryCount <= config.getPullRetryCount()) {
            List remaining;
            allDone = true;
            long thisWait = config.getPullTimeoutSeconds() + retryCount * config.getPullRetryIncreaseSeconds();
            for (Map.Entry entry : pircMap.entrySet()) {
                boolean done = false;
                try {
                    if (entry.getValue() == null) continue;
                    log.debug("waiting on image " + (String)entry.getKey() + " for " + thisWait + " seconds " + (platform == null ? "" : " for platform " + platform));
                    done = ((PullImageResultCallback)entry.getValue()).awaitCompletion(thisWait, TimeUnit.SECONDS);
                    if (done) {
                        log.debug("success for image " + (String)entry.getKey());
                    }
                }
                catch (InterruptedException ie) {
                    throw BuildpackException.launderThrowable(ie);
                }
                catch (DockerClientException dce) {
                    lastSeen = dce;
                }
                catch (NotFoundException nfe) {
                    lastSeen = nfe;
                }
                if (!done) {
                    String imageName = (String)entry.getKey();
                    PullImageResultCallback newPirc = new PullImageResultCallback();
                    if (platform != null) {
                        dc.pullImageCmd(imageName).withPlatform(platform).exec((ResultCallback)newPirc);
                    } else {
                        dc.pullImageCmd(imageName).exec((ResultCallback)newPirc);
                    }
                    entry.setValue(newPirc);
                    allDone = false;
                    continue;
                }
                entry.setValue(null);
            }
            if (++retryCount > config.getPullRetryCount()) continue;
            if (lastSeen != null) {
                log.debug("Error during pull " + lastSeen.getMessage());
            }
            if ((remaining = pircMap.entrySet().stream().filter(e -> e.getValue() != null).map(i -> (String)i.getKey()).collect(Collectors.toList())).isEmpty()) continue;
            log.debug("Retrying (" + retryCount + ") for " + remaining);
        }
        if (lastSeen != null && !allDone) {
            throw lastSeen;
        }
    }

    public static ImageInfo inspectImage(DockerClient dc, ImageReference image) {
        String imageName = image.getReferenceWithLatest();
        InspectImageResponse iir = dc.inspectImageCmd(imageName).exec();
        ImageInfo ii = new ImageInfo();
        ii.id = iir.getId();
        if (iir.getRepoDigests() != null) {
            ii.digest = iir.getRepoDigests().toString();
        }
        if (iir.getRepoTags() != null) {
            ii.tags = iir.getRepoTags().toString();
        }
        ii.labels = iir.getConfig().getLabels();
        ii.env = iir.getConfig().getEnv();
        ii.platform = iir.getArch() != null && !iir.getArch().isEmpty() && iir.getOs() != null && !iir.getOs().isEmpty() ? iir.getOs() + "/" + iir.getArch() : null;
        return ii;
    }

    public static class ImageInfo {
        public String id;
        public String digest;
        public String tags;
        public Map<String, String> labels;
        public String[] env;
        public String platform;
    }
}

