/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.lifecycle;

import dev.snowdrop.buildpack.BuilderImage;
import dev.snowdrop.buildpack.config.CacheConfig;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.LogConfig;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.Content;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import dev.snowdrop.buildpack.docker.VolumeUtils;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhase;
import dev.snowdrop.buildpack.lifecycle.Version;
import dev.snowdrop.buildpack.lifecycle.phases.Analyzer;
import dev.snowdrop.buildpack.lifecycle.phases.Builder;
import dev.snowdrop.buildpack.lifecycle.phases.Creator;
import dev.snowdrop.buildpack.lifecycle.phases.Detector;
import dev.snowdrop.buildpack.lifecycle.phases.Exporter;
import dev.snowdrop.buildpack.lifecycle.phases.Extender;
import dev.snowdrop.buildpack.lifecycle.phases.Restorer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecyclePhaseFactory {
    private static final Logger log = LoggerFactory.getLogger(LifecyclePhaseFactory.class);
    public static final String CACHE_VOL_PATH = "/cache-dir";
    public static final String LAUNCH_CACHE_VOL_PATH = "/launch-cache-dir";
    public static final String WORKSPACE_VOL_PATH = "/workspace";
    public static final String LAYERS_VOL_PATH = "/layers";
    public static final String PLATFORM_VOL_PATH = "/platform";
    public static final String KANIKO_VOL_PATH = "/kaniko";
    public static final String DOCKER_SOCKET_PATH = "/var/run/docker.sock";
    public static final String APP_PATH_PREFIX = "";
    public static final String ENV_PATH_PREFIX = "";
    private final DockerConfig dockerConfig;
    private final CacheConfig buildCacheConfig;
    private final CacheConfig launchCacheConfig;
    private final CacheConfig kanikoCacheConfig;
    private final PlatformConfig platformConfig;
    private final LogConfig logConfig;
    private final ImageReference outputImage;
    private final BuilderImage originalBuilder;
    private final BuilderImage builder;
    private final Version platformLevel;
    final String buildCacheVolume;
    final String launchCacheVolume;
    final String kanikoCacheVolume;
    final String applicationVolume;
    final String outputVolume;
    final String platformVolume;

    private String randomString(int length) {
        return new Random().ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private String getVolumeName(CacheConfig config, String prefix) {
        String volumeName = config != null && config.getCacheVolumeName() != null ? config.getCacheVolumeName() : prefix + this.randomString(10);
        return volumeName;
    }

    public String getContainerForPhase(String[] args, Integer runAsId) {
        ArrayList<VolumeBind> binds = new ArrayList<VolumeBind>(Arrays.asList(new VolumeBind(this.buildCacheVolume, CACHE_VOL_PATH), new VolumeBind(this.launchCacheVolume, LAUNCH_CACHE_VOL_PATH), new VolumeBind(this.applicationVolume, WORKSPACE_VOL_PATH), new VolumeBind(this.platformVolume, PLATFORM_VOL_PATH), new VolumeBind(this.outputVolume, LAYERS_VOL_PATH), new VolumeBind(this.kanikoCacheVolume, KANIKO_VOL_PATH)));
        if (this.dockerConfig.getUseDaemon().booleanValue()) {
            binds.add(new VolumeBind(this.dockerConfig.getDockerSocket(), DOCKER_SOCKET_PATH));
        }
        String id = ContainerUtils.createContainer(this.dockerConfig.getDockerClient(), this.builder.getImage().getCanonicalReference(), Arrays.asList(args), runAsId, this.platformConfig.getEnvironment(), "label=disable", this.dockerConfig.getDockerNetwork(), binds);
        log.debug("- mounted " + this.buildCacheVolume + " at " + CACHE_VOL_PATH);
        log.debug("- mounted " + this.launchCacheVolume + " at " + LAUNCH_CACHE_VOL_PATH);
        log.debug("- mounted " + this.kanikoCacheVolume + " at " + KANIKO_VOL_PATH);
        log.debug("- mounted " + this.applicationVolume + " at " + WORKSPACE_VOL_PATH);
        log.debug("- mounted " + this.platformVolume + " at " + PLATFORM_VOL_PATH);
        if (this.dockerConfig.getUseDaemon().booleanValue()) {
            log.debug("- mounted " + this.dockerConfig.getDockerSocket() + " at " + DOCKER_SOCKET_PATH);
        }
        log.debug("- mounted " + this.outputVolume + " at " + LAYERS_VOL_PATH);
        log.debug("- container id " + id);
        log.debug("- image reference " + this.builder.getImage().getCanonicalReference());
        return id;
    }

    public LifecyclePhaseFactory(DockerConfig dockerConfig, CacheConfig buildCacheConfig, CacheConfig launchCacheConfig, CacheConfig kanikoCacheConfig, PlatformConfig platformConfig, LogConfig logConfig, ImageReference outputImage, BuilderImage originalBuilder, BuilderImage extendedBuilder, String platformLevel) {
        this.buildCacheVolume = this.getVolumeName(buildCacheConfig, "buildpack-build-");
        this.launchCacheVolume = this.getVolumeName(launchCacheConfig, "buildpack-launch-");
        this.applicationVolume = this.getVolumeName(null, "buildpack-app-");
        this.outputVolume = this.getVolumeName(null, "buildpack-output-");
        this.platformVolume = this.getVolumeName(null, "buildpack-platform-");
        this.kanikoCacheVolume = this.getVolumeName(kanikoCacheConfig, "buildpack-kaniko-");
        this.dockerConfig = dockerConfig;
        this.buildCacheConfig = buildCacheConfig;
        this.launchCacheConfig = launchCacheConfig;
        this.kanikoCacheConfig = kanikoCacheConfig;
        this.platformConfig = platformConfig;
        this.logConfig = logConfig;
        this.outputImage = outputImage;
        this.originalBuilder = originalBuilder;
        this.builder = extendedBuilder;
        this.platformLevel = new Version(platformLevel);
    }

    public void createVolumes(List<Content> content) {
        VolumeUtils.createVolumeIfRequired(this.dockerConfig.getDockerClient(), this.buildCacheVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerConfig.getDockerClient(), this.launchCacheVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerConfig.getDockerClient(), this.applicationVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerConfig.getDockerClient(), this.outputVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerConfig.getDockerClient(), this.platformVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerConfig.getDockerClient(), this.kanikoCacheVolume);
        log.debug("There are " + content.size() + " entries to add for the app dir");
        List<ContainerEntry> appEntries = content.stream().flatMap(c -> c.getContainerEntries().stream()).collect(Collectors.toList());
        log.info("Adding application to volume " + this.applicationVolume);
        VolumeUtils.addContentToVolume(this.dockerConfig.getDockerClient(), this.applicationVolume, this.builder.getImage().getCanonicalReference(), "", this.builder.getUserId(), this.builder.getGroupId(), appEntries);
        if (!this.platformConfig.getEnvironment().containsKey("CNB_PLATFORM_API")) {
            this.platformConfig.getEnvironment().put("CNB_PLATFORM_API", this.platformLevel.toString());
        }
        if (this.platformConfig.getEnvironment().containsKey("CNB_REGISTRY_AUTH") && this.dockerConfig.getAuthConfigs().size() > 0) {
            log.warn("Registry auth configs passed while CNB_REGISTRY_AUTH is set, if values do not agree, behavior is undefined");
        }
        if (!this.platformConfig.getEnvironment().containsKey("CNB_REGISTRY_AUTH")) {
            String registryJson = "{}";
            if (this.dockerConfig.getAuthConfigs().size() > 0) {
                registryJson = "{ ";
                for (RegistryAuthConfig rac : this.dockerConfig.getAuthConfigs()) {
                    if (registryJson.length() > 3) {
                        registryJson = registryJson + ", ";
                    }
                    if (rac.getUsername() != null && rac.getPassword() != null) {
                        String b64auth = Base64.getEncoder().encodeToString((rac.getUsername() + ":" + rac.getPassword()).getBytes());
                        registryJson = registryJson + " \"" + rac.getRegistryAddress() + "\":\"Basic " + b64auth + "\" ";
                        continue;
                    }
                    if (rac.getAuth() != null) {
                        registryJson = registryJson + " \"" + rac.getRegistryAddress() + "\":\"Basic " + rac.getAuth() + "\" ";
                        continue;
                    }
                    if (rac.getRegistryToken() != null) {
                        registryJson = registryJson + " \"" + rac.getRegistryAddress() + "\":\"Bearer " + rac.getRegistryToken() + "\" ";
                        continue;
                    }
                    log.warn("Unknown auth type represented by AuthConfig");
                    throw new IllegalStateException("Unsupported AuthConfig");
                }
                registryJson = registryJson + " } ";
            }
            this.platformConfig.getEnvironment().put("CNB_REGISTRY_AUTH", registryJson);
        }
        if (this.builder.hasExtensions() && this.platformLevel.atLeast("0.10") && !this.platformConfig.getEnvironment().containsKey("CNB_EXPERIMENTAL_MODE")) {
            log.info("Builder uses extensions, enabling experimental features.");
            this.platformConfig.getEnvironment().put("CNB_EXPERIMENTAL_MODE", "warn");
        }
        List<ContainerEntry> envEntries = this.platformConfig.getEnvironment().entrySet().stream().flatMap(e -> new StringContent("env/" + (String)e.getKey(), 511, (String)e.getValue()).getContainerEntries().stream()).collect(Collectors.toList());
        log.info("Adding platform entries to platform volume " + this.platformVolume);
        VolumeUtils.addContentToVolume(this.dockerConfig.getDockerClient(), this.platformVolume, this.builder.getImage().getCanonicalReference(), "", this.builder.getUserId(), this.builder.getGroupId(), envEntries);
    }

    public void tidyUp() {
        log.info("Post Build cleanup activites:");
        if (this.buildCacheConfig.getDeleteCacheAfterBuild().booleanValue()) {
            VolumeUtils.removeVolume(this.dockerConfig.getDockerClient(), this.buildCacheVolume);
        }
        if (this.launchCacheConfig.getDeleteCacheAfterBuild().booleanValue()) {
            VolumeUtils.removeVolume(this.dockerConfig.getDockerClient(), this.launchCacheVolume);
        }
        if (this.kanikoCacheConfig.getDeleteCacheAfterBuild().booleanValue()) {
            VolumeUtils.removeVolume(this.dockerConfig.getDockerClient(), this.kanikoCacheVolume);
        }
        VolumeUtils.removeVolume(this.dockerConfig.getDockerClient(), this.applicationVolume);
        VolumeUtils.removeVolume(this.dockerConfig.getDockerClient(), this.outputVolume);
        VolumeUtils.removeVolume(this.dockerConfig.getDockerClient(), this.platformVolume);
        log.info("- temporary build volumes removed");
    }

    public void addContentToLayersVolume(StringContent content) {
        VolumeUtils.addContentToVolume(this.dockerConfig.getDockerClient(), this.outputVolume, this.builder.getImage().getCanonicalReference(), "", this.builder.getUserId(), this.builder.getGroupId(), content.getContainerEntries());
    }

    public BuilderImage getBuilderImage() {
        return this.builder;
    }

    public DockerConfig getDockerConfig() {
        return this.dockerConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public ImageReference getOutputImage() {
        return this.outputImage;
    }

    public Version getPlatformLevel() {
        return this.platformLevel;
    }

    public LifecyclePhase getCreator() {
        return new Creator(this);
    }

    public LifecyclePhase getAnalyzer() {
        return new Analyzer(this);
    }

    public LifecyclePhase getDetector() {
        return new Detector(this);
    }

    public LifecyclePhase getRestorer() {
        return new Restorer(this, this.originalBuilder);
    }

    public LifecyclePhase getBuilder() {
        return new Builder(this);
    }

    public LifecyclePhase getBuildImageExtender() {
        return this.getExtender("build");
    }

    public LifecyclePhase getRunImageExtender() {
        return this.getExtender("run");
    }

    public LifecyclePhase getExtender(String kind) {
        return new Extender(this, kind);
    }

    public LifecyclePhase getExporter(boolean extended) {
        return new Exporter(this, extended);
    }
}

