/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import dev.snowdrop.buildpack.BuildpackBuilder;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.ContainerLogReader;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.SystemLogger;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.Content;
import dev.snowdrop.buildpack.docker.DockerClientUtils;
import dev.snowdrop.buildpack.docker.ImageUtils;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import dev.snowdrop.buildpack.docker.VolumeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class Buildpack {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Buildpack.class);
    private final String BUILD_VOL_PATH = "/bld";
    private final String LAUNCH_VOL_PATH = "/launch";
    private final String APP_VOL_PATH = "/app";
    private final String OUTPUT_VOL_PATH = "/out";
    private final String PLATFORM_VOL_PATH = "/platform";
    private static final String DEFAULT_BUILD_IMAGE = "paketobuildpacks/builder:base";
    private static final Integer DEFAULT_PULL_TIMEOUT = 60;
    private static final String DEFAULT_LOG_LEVEL = "debug";
    private final String buildImage;
    private final String finalImage;
    private String runImage;
    private final Integer pullTimeoutSeconds;
    private final String dockerHost;
    private final boolean useDaemon;
    private final String buildCacheVolumeName;
    private final boolean removeBuildCacheAfterBuild;
    private final String launchCacheVolumeName;
    private final boolean removeLaunchCacheAfterBuild;
    private final String logLevel;
    private final boolean useTimestamps;
    private Integer userId;
    private Integer groupId;
    Map<String, String> environment = new HashMap<String, String>();
    private List<Content> content = new LinkedList<Content>();
    private final DockerClient dockerClient;
    private final Logger logger;

    public static BuildpackBuilder builder() {
        return new BuildpackBuilder();
    }

    public Buildpack(String buildImage, String runImage, String finalImage, Integer pullTimeoutSeconds, String dockerHost, boolean useDaemon, String buildCacheVolumeName, boolean removeBuildCacheAfterBuild, String launchCacheVolumeName, boolean removeLaunchCacheAfterBuild, String logLevel, boolean useTimestamps, Map<String, String> environment, List<Content> content, DockerClient dockerClient, Logger logger) {
        this.buildImage = buildImage != null ? buildImage : DEFAULT_BUILD_IMAGE;
        this.runImage = runImage;
        this.finalImage = finalImage;
        this.pullTimeoutSeconds = pullTimeoutSeconds != null ? pullTimeoutSeconds : DEFAULT_PULL_TIMEOUT;
        this.dockerHost = dockerHost;
        this.useDaemon = useDaemon;
        this.buildCacheVolumeName = buildCacheVolumeName;
        this.removeBuildCacheAfterBuild = removeBuildCacheAfterBuild;
        this.launchCacheVolumeName = launchCacheVolumeName;
        this.removeLaunchCacheAfterBuild = removeLaunchCacheAfterBuild;
        this.logLevel = logLevel != null ? logLevel : DEFAULT_LOG_LEVEL;
        this.useTimestamps = useTimestamps;
        this.environment = environment != null ? environment : new HashMap();
        this.content = content;
        this.dockerClient = DockerClientUtils.getDockerClient(dockerHost);
        this.logger = logger != null ? logger : new SystemLogger();
        this.build(this.logger);
    }

    private int build(Logger logger) {
        log.info("Buildpack build invoked, preparing environment...");
        this.prep();
        String buildCacheVolume = this.buildCacheVolumeName == null ? "buildpack-build-" + this.randomString(10) : this.buildCacheVolumeName;
        String launchCacheVolume = this.launchCacheVolumeName == null ? "buildpack-launch-" + this.randomString(10) : this.launchCacheVolumeName;
        String applicationVolume = "buildpack-app-" + this.randomString(10);
        String outputVolume = "buildpack-output-" + this.randomString(10);
        String platformVolume = "buildpack-platform-" + this.randomString(10);
        VolumeUtils.createVolumeIfRequired(this.dockerClient, buildCacheVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerClient, launchCacheVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerClient, applicationVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerClient, outputVolume);
        VolumeUtils.createVolumeIfRequired(this.dockerClient, platformVolume);
        log.info("- build volumes created");
        String[] xargs = new String[]{"bash", "-c", "ls -alR /platform"};
        String[] args = new String[]{"/cnb/lifecycle/creator", "-uid", "" + this.userId, "-gid", "" + this.groupId, "-cache-dir", "/bld", "-app", "/app/content", "-layers", "/out", "-platform", "/platform", "-run-image", this.runImage, "-launch-cache", "/launch", "-daemon", "-log-level", this.logLevel, "-skip-restore", this.finalImage};
        String dockerSocket = "/var/run/docker.sock";
        if (this.dockerHost != null && this.dockerHost.startsWith("unix://")) {
            dockerSocket = this.dockerHost.substring("unix://".length());
        }
        String id = ContainerUtils.createContainer(this.dockerClient, this.buildImage, Arrays.asList(args), new VolumeBind(buildCacheVolume, "/bld"), new VolumeBind(launchCacheVolume, "/launch"), new VolumeBind(applicationVolume, "/app"), new VolumeBind(dockerSocket, "/var/run/docker.sock"), new VolumeBind(outputVolume, "/out"));
        log.info("- mounted " + buildCacheVolume + " at " + "/bld");
        log.info("- mounted " + launchCacheVolume + " at " + "/launch");
        log.info("- mounted " + applicationVolume + " at " + "/app");
        log.info("- mounted " + platformVolume + " at " + "/platform");
        log.info("- mounted " + dockerSocket + " at /var/run/docker.sock");
        log.info("- mounted " + outputVolume + " at " + "/out");
        log.info("- build container id " + id);
        List<ContainerEntry> appEntries = this.content.stream().flatMap(c -> c.getContainerEntries().stream()).collect(Collectors.toList());
        ContainerUtils.addContentToContainer(this.dockerClient, id, "/app/content", this.userId, this.groupId, appEntries);
        log.info("- uploaded archive to container at /app/content");
        List<ContainerEntry> envEntries = this.environment.entrySet().stream().flatMap(e -> new StringContent((String)e.getKey(), (String)e.getValue()).getContainerEntries().stream()).collect(Collectors.toList());
        ContainerUtils.addContentToContainer(this.dockerClient, id, "/platform/env", this.userId, this.groupId, envEntries);
        log.info("- uploaded env to container at /platform/env");
        log.info("- launching build container");
        this.dockerClient.startContainerCmd(id).exec();
        log.info("- attaching log relay");
        this.dockerClient.logContainerCmd(id).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(this.useTimestamps)).exec((ResultCallback)new ContainerLogReader(logger));
        int rc = ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(id).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        log.info("Buildpack build complete, with exit code " + rc);
        ContainerUtils.removeContainer(this.dockerClient, id);
        if (this.removeBuildCacheAfterBuild || this.buildCacheVolumeName == null) {
            VolumeUtils.removeVolume(this.dockerClient, buildCacheVolume);
        }
        if (this.removeLaunchCacheAfterBuild || this.launchCacheVolumeName == null) {
            VolumeUtils.removeVolume(this.dockerClient, launchCacheVolume);
        }
        VolumeUtils.removeVolume(this.dockerClient, applicationVolume);
        VolumeUtils.removeVolume(this.dockerClient, outputVolume);
        VolumeUtils.removeVolume(this.dockerClient, platformVolume);
        return rc;
    }

    private void prep() {
        ImageUtils.pullImages(this.dockerClient, this.pullTimeoutSeconds, this.buildImage);
        ImageUtils.ImageInfo ii = ImageUtils.inspectImage(this.dockerClient, this.buildImage);
        for (String s : ii.env) {
            if (s.startsWith("CNB_USER_ID=")) {
                this.userId = Integer.valueOf(s.substring("CNB_USER_ID=".length()));
            }
            if (!s.startsWith("CNB_GROUP_ID=")) continue;
            this.groupId = Integer.valueOf(s.substring("CNB_GROUP_ID=".length()));
        }
        if (this.environment.containsKey("CNB_USER_ID")) {
            this.userId = Integer.valueOf(this.environment.get("CNB_USER_ID"));
        }
        if (this.environment.containsKey("CNB_GROUP_ID")) {
            this.userId = Integer.valueOf(this.environment.get("CNB_GROUP_ID"));
        }
        String metadataJson = ii.labels.get("io.buildpacks.builder.metadata");
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonNode root = om.readTree(metadataJson);
            String ri = this.getValue(root, "stack/runImage/image");
            if (this.runImage == null) {
                if (ri == null) {
                    throw new Exception("No runImage specified, and builderImage is missing metadata declaration");
                }
                if (ri.startsWith("index.docker.io/")) {
                    ri = ri.substring("index.docker.io/".length());
                    ri = "docker.io/" + ri;
                }
                this.runImage = ri;
            }
        }
        catch (Exception e) {
            throw BuildpackException.launderThrowable(e);
        }
        ImageUtils.pullImages(this.dockerClient, this.pullTimeoutSeconds, this.runImage);
        log.info("Build configured with..");
        log.info("- build image : " + this.buildImage);
        log.info("- run image : " + this.runImage);
    }

    private String getValue(JsonNode root, String path) {
        String[] parts = path.split("/");
        JsonNode next = root.get(parts[0]);
        if (next != null && parts.length > 1) {
            return this.getValue(next, path.substring(path.indexOf("/") + 1));
        }
        if (next == null) {
            return null;
        }
        return next.asText();
    }

    private String randomString(int length) {
        return new Random().ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public String getBuildImage() {
        return this.buildImage;
    }

    public String getRunImage() {
        return this.runImage;
    }

    public String getFinalImage() {
        return this.finalImage;
    }

    public Integer getPullTimeoutSeconds() {
        return this.pullTimeoutSeconds;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public boolean getUseDaemon() {
        return this.useDaemon;
    }

    public String getBuildCacheVolumeName() {
        return this.buildCacheVolumeName;
    }

    public boolean getRemoveBuildCacheAfterBuild() {
        return this.removeBuildCacheAfterBuild;
    }

    public String getLaunchCacheVolumeName() {
        return this.launchCacheVolumeName;
    }

    public boolean getRemoveLaunchCacheAfterBuild() {
        return this.removeLaunchCacheAfterBuild;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean getUseTimestamps() {
        return this.useTimestamps;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public List<Content> getContent() {
        return this.content;
    }

    public void setContent(List<Content> content) {
        this.content = content;
    }

    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

