/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.Buildpack;
import dev.snowdrop.buildpack.BuildpackFluent;
import dev.snowdrop.buildpack.BuildpackFluentImpl;
import dev.snowdrop.buildpack.EditableBuildpack;
import dev.snowdrop.buildpack.builder.VisitableBuilder;
import java.util.Objects;

public class BuildpackBuilder
extends BuildpackFluentImpl<BuildpackBuilder>
implements VisitableBuilder<Buildpack, BuildpackBuilder> {
    BuildpackFluent<?> fluent;
    Boolean validationEnabled;

    public BuildpackBuilder() {
        this(false);
    }

    public BuildpackBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public BuildpackBuilder(BuildpackFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildpackBuilder(BuildpackFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public BuildpackBuilder(BuildpackFluent<?> fluent, Buildpack instance) {
        this(fluent, instance, false);
    }

    public BuildpackBuilder(BuildpackFluent<?> fluent, Buildpack instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBuildImage(instance.getBuildImage());
        fluent.withRunImage(instance.getRunImage());
        fluent.withFinalImage(instance.getFinalImage());
        fluent.withPullTimeoutSeconds(instance.getPullTimeoutSeconds());
        fluent.withDockerHost(instance.getDockerHost());
        fluent.withUseDaemon(instance.getUseDaemon());
        fluent.withBuildCacheVolumeName(instance.getBuildCacheVolumeName());
        fluent.withRemoveBuildCacheAfterBuild(instance.getRemoveBuildCacheAfterBuild());
        fluent.withLaunchCacheVolumeName(instance.getLaunchCacheVolumeName());
        fluent.withRemoveLaunchCacheAfterBuild(instance.getRemoveLaunchCacheAfterBuild());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withUseTimestamps(instance.getUseTimestamps());
        fluent.withEnvironment(instance.getEnvironment());
        fluent.withContent(instance.getContent());
        fluent.withDockerClient(instance.getDockerClient());
        fluent.withLogger(instance.getLogger());
        this.validationEnabled = validationEnabled;
    }

    public BuildpackBuilder(Buildpack instance) {
        this(instance, (Boolean)false);
    }

    public BuildpackBuilder(Buildpack instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBuildImage(instance.getBuildImage());
        this.withRunImage(instance.getRunImage());
        this.withFinalImage(instance.getFinalImage());
        this.withPullTimeoutSeconds(instance.getPullTimeoutSeconds());
        this.withDockerHost(instance.getDockerHost());
        this.withUseDaemon(instance.getUseDaemon());
        this.withBuildCacheVolumeName(instance.getBuildCacheVolumeName());
        this.withRemoveBuildCacheAfterBuild(instance.getRemoveBuildCacheAfterBuild());
        this.withLaunchCacheVolumeName(instance.getLaunchCacheVolumeName());
        this.withRemoveLaunchCacheAfterBuild(instance.getRemoveLaunchCacheAfterBuild());
        this.withLogLevel(instance.getLogLevel());
        this.withUseTimestamps(instance.getUseTimestamps());
        this.withEnvironment(instance.getEnvironment());
        this.withContent(instance.getContent());
        this.withDockerClient(instance.getDockerClient());
        this.withLogger(instance.getLogger());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableBuildpack build() {
        EditableBuildpack buildable = new EditableBuildpack(this.fluent.getBuildImage(), this.fluent.getRunImage(), this.fluent.getFinalImage(), this.fluent.getPullTimeoutSeconds(), this.fluent.getDockerHost(), this.fluent.isUseDaemon(), this.fluent.getBuildCacheVolumeName(), this.fluent.isRemoveBuildCacheAfterBuild(), this.fluent.getLaunchCacheVolumeName(), this.fluent.isRemoveLaunchCacheAfterBuild(), this.fluent.getLogLevel(), this.fluent.isUseTimestamps(), this.fluent.getEnvironment(), this.fluent.getContent(), this.fluent.getDockerClient(), this.fluent.getLogger());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildpackBuilder that = (BuildpackBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

