/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import com.github.dockerjava.api.DockerClient;
import dev.snowdrop.buildpack.Buildpack;
import dev.snowdrop.buildpack.BuildpackFluent;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.Slf4jLogger;
import dev.snowdrop.buildpack.Slf4jLoggerBuilder;
import dev.snowdrop.buildpack.Slf4jLoggerFluentImpl;
import dev.snowdrop.buildpack.SystemLogger;
import dev.snowdrop.buildpack.SystemLoggerBuilder;
import dev.snowdrop.buildpack.SystemLoggerFluentImpl;
import dev.snowdrop.buildpack.builder.BaseFluent;
import dev.snowdrop.buildpack.builder.Nested;
import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.docker.Content;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.FileContentBuilder;
import dev.snowdrop.buildpack.docker.FileContentFluentImpl;
import dev.snowdrop.buildpack.docker.StreamContent;
import dev.snowdrop.buildpack.docker.StreamContentBuilder;
import dev.snowdrop.buildpack.docker.StreamContentFluentImpl;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.StringContentBuilder;
import dev.snowdrop.buildpack.docker.StringContentFluentImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildpackFluentImpl<A extends BuildpackFluent<A>>
extends BaseFluent<A>
implements BuildpackFluent<A> {
    private String buildImage;
    private String finalImage;
    private String runImage;
    private Integer pullTimeoutSeconds;
    private String dockerHost;
    private boolean useDaemon;
    private String buildCacheVolumeName;
    private boolean removeBuildCacheAfterBuild;
    private String launchCacheVolumeName;
    private boolean removeLaunchCacheAfterBuild;
    private String logLevel;
    private boolean useTimestamps;
    private Map<String, String> environment;
    private ArrayList<VisitableBuilder<? extends Content, ?>> content;
    private DockerClient dockerClient;
    private VisitableBuilder<? extends Logger, ?> logger;

    public BuildpackFluentImpl() {
    }

    public BuildpackFluentImpl(Buildpack instance) {
        this.withBuildImage(instance.getBuildImage());
        this.withRunImage(instance.getRunImage());
        this.withFinalImage(instance.getFinalImage());
        this.withPullTimeoutSeconds(instance.getPullTimeoutSeconds());
        this.withDockerHost(instance.getDockerHost());
        this.withUseDaemon(instance.getUseDaemon());
        this.withBuildCacheVolumeName(instance.getBuildCacheVolumeName());
        this.withRemoveBuildCacheAfterBuild(instance.getRemoveBuildCacheAfterBuild());
        this.withLaunchCacheVolumeName(instance.getLaunchCacheVolumeName());
        this.withRemoveLaunchCacheAfterBuild(instance.getRemoveLaunchCacheAfterBuild());
        this.withLogLevel(instance.getLogLevel());
        this.withUseTimestamps(instance.getUseTimestamps());
        this.withEnvironment(instance.getEnvironment());
        this.withContent(instance.getContent());
        this.withDockerClient(instance.getDockerClient());
        this.withLogger(instance.getLogger());
    }

    @Override
    public String getBuildImage() {
        return this.buildImage;
    }

    @Override
    public A withBuildImage(String buildImage) {
        this.buildImage = buildImage;
        return (A)this;
    }

    @Override
    public Boolean hasBuildImage() {
        return this.buildImage != null;
    }

    @Override
    public String getFinalImage() {
        return this.finalImage;
    }

    @Override
    public A withFinalImage(String finalImage) {
        this.finalImage = finalImage;
        return (A)this;
    }

    @Override
    public Boolean hasFinalImage() {
        return this.finalImage != null;
    }

    @Override
    public String getRunImage() {
        return this.runImage;
    }

    @Override
    public A withRunImage(String runImage) {
        this.runImage = runImage;
        return (A)this;
    }

    @Override
    public Boolean hasRunImage() {
        return this.runImage != null;
    }

    @Override
    public Integer getPullTimeoutSeconds() {
        return this.pullTimeoutSeconds;
    }

    @Override
    public A withPullTimeoutSeconds(Integer pullTimeoutSeconds) {
        this.pullTimeoutSeconds = pullTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasPullTimeoutSeconds() {
        return this.pullTimeoutSeconds != null;
    }

    @Override
    public String getDockerHost() {
        return this.dockerHost;
    }

    @Override
    public A withDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
        return (A)this;
    }

    @Override
    public Boolean hasDockerHost() {
        return this.dockerHost != null;
    }

    @Override
    public boolean isUseDaemon() {
        return this.useDaemon;
    }

    @Override
    public A withUseDaemon(boolean useDaemon) {
        this.useDaemon = useDaemon;
        return (A)this;
    }

    @Override
    public Boolean hasUseDaemon() {
        return true;
    }

    @Override
    public String getBuildCacheVolumeName() {
        return this.buildCacheVolumeName;
    }

    @Override
    public A withBuildCacheVolumeName(String buildCacheVolumeName) {
        this.buildCacheVolumeName = buildCacheVolumeName;
        return (A)this;
    }

    @Override
    public Boolean hasBuildCacheVolumeName() {
        return this.buildCacheVolumeName != null;
    }

    @Override
    public boolean isRemoveBuildCacheAfterBuild() {
        return this.removeBuildCacheAfterBuild;
    }

    @Override
    public A withRemoveBuildCacheAfterBuild(boolean removeBuildCacheAfterBuild) {
        this.removeBuildCacheAfterBuild = removeBuildCacheAfterBuild;
        return (A)this;
    }

    @Override
    public Boolean hasRemoveBuildCacheAfterBuild() {
        return true;
    }

    @Override
    public String getLaunchCacheVolumeName() {
        return this.launchCacheVolumeName;
    }

    @Override
    public A withLaunchCacheVolumeName(String launchCacheVolumeName) {
        this.launchCacheVolumeName = launchCacheVolumeName;
        return (A)this;
    }

    @Override
    public Boolean hasLaunchCacheVolumeName() {
        return this.launchCacheVolumeName != null;
    }

    @Override
    public boolean isRemoveLaunchCacheAfterBuild() {
        return this.removeLaunchCacheAfterBuild;
    }

    @Override
    public A withRemoveLaunchCacheAfterBuild(boolean removeLaunchCacheAfterBuild) {
        this.removeLaunchCacheAfterBuild = removeLaunchCacheAfterBuild;
        return (A)this;
    }

    @Override
    public Boolean hasRemoveLaunchCacheAfterBuild() {
        return true;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public boolean isUseTimestamps() {
        return this.useTimestamps;
    }

    @Override
    public A withUseTimestamps(boolean useTimestamps) {
        this.useTimestamps = useTimestamps;
        return (A)this;
    }

    @Override
    public Boolean hasUseTimestamps() {
        return true;
    }

    @Override
    public A addToEnvironment(String key, String value) {
        if (this.environment == null && key != null && value != null) {
            this.environment = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.environment.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToEnvironment(Map<String, String> map) {
        if (this.environment == null && map != null) {
            this.environment = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.environment.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvironment(String key) {
        if (this.environment == null) {
            return (A)this;
        }
        if (key != null && this.environment != null) {
            this.environment.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvironment(Map<String, String> map) {
        if (this.environment == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.environment == null) continue;
                this.environment.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public <K, V> A withEnvironment(Map<String, String> environment) {
        this.environment = environment == null ? null : new LinkedHashMap<String, String>(environment);
        return (A)this;
    }

    @Override
    public Boolean hasEnvironment() {
        return this.environment != null;
    }

    @Override
    public A addToContent(VisitableBuilder<? extends Content, ?> builder) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        this._visitables.get("content").add(builder);
        this.content.add(builder);
        return (A)this;
    }

    @Override
    public A addToContent(Integer index, VisitableBuilder<? extends Content, ?> builder) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        this._visitables.get("content").add(index, builder);
        this.content.add(index, builder);
        return (A)this;
    }

    @Override
    public A addToContent(Integer index, Content item) {
        if (item instanceof FileContent) {
            this.addToFileContent(index, (FileContent)item);
        } else if (item instanceof StreamContent) {
            this.addToStreamContent(index, (StreamContent)item);
        } else if (item instanceof StringContent) {
            this.addToStringContent(index, (StringContent)item);
        }
        return (A)this;
    }

    @Override
    public A setToContent(Integer index, Content item) {
        if (item instanceof FileContent) {
            this.setToFileContent(index, (FileContent)item);
        } else if (item instanceof StreamContent) {
            this.setToStreamContent(index, (StreamContent)item);
        } else if (item instanceof StringContent) {
            this.setToStringContent(index, (StringContent)item);
        }
        return (A)this;
    }

    @Override
    public A addToContent(Content ... items) {
        if (items != null && items.length > 0 && this.content == null) {
            this.content = new ArrayList();
        }
        for (Content item : items) {
            if (item instanceof FileContent) {
                this.addToFileContent((FileContent)item);
                continue;
            }
            if (item instanceof StreamContent) {
                this.addToStreamContent((StreamContent)item);
                continue;
            }
            if (item instanceof StringContent) {
                this.addToStringContent((StringContent)item);
                continue;
            }
            VisitableBuilder<Content, ?> builder = BuildpackFluentImpl.builderOf(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContent(Collection<Content> items) {
        if (items != null && items.size() > 0 && this.content == null) {
            this.content = new ArrayList();
        }
        for (Content item : items) {
            if (item instanceof FileContent) {
                this.addToFileContent((FileContent)item);
                continue;
            }
            if (item instanceof StreamContent) {
                this.addToStreamContent((StreamContent)item);
                continue;
            }
            if (item instanceof StringContent) {
                this.addToStringContent((StringContent)item);
                continue;
            }
            VisitableBuilder<Content, ?> builder = BuildpackFluentImpl.builderOf(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContent(VisitableBuilder<? extends Content, ?> builder) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        this._visitables.get("content").remove(builder);
        this.content.remove(builder);
        return (A)this;
    }

    @Override
    public A removeFromContent(Content ... items) {
        for (Content item : items) {
            if (item instanceof FileContent) {
                this.removeFromFileContent((FileContent)item);
                continue;
            }
            if (item instanceof StreamContent) {
                this.removeFromStreamContent((StreamContent)item);
                continue;
            }
            if (item instanceof StringContent) {
                this.removeFromStringContent((StringContent)item);
                continue;
            }
            VisitableBuilder<Content, ?> builder = BuildpackFluentImpl.builderOf(item);
            this._visitables.get("content").remove(builder);
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContent(Collection<Content> items) {
        for (Content item : items) {
            if (item instanceof FileContent) {
                this.removeFromFileContent((FileContent)item);
                continue;
            }
            if (item instanceof StreamContent) {
                this.removeFromStreamContent((StreamContent)item);
                continue;
            }
            if (item instanceof StringContent) {
                this.removeFromStringContent((StringContent)item);
                continue;
            }
            VisitableBuilder<Content, ?> builder = BuildpackFluentImpl.builderOf(item);
            this._visitables.get("content").remove(builder);
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Content> getContent() {
        return BuildpackFluentImpl.build(this.content);
    }

    @Override
    public List<Content> buildContent() {
        return BuildpackFluentImpl.build(this.content);
    }

    @Override
    public Content buildContent(Integer index) {
        return (Content)this.content.get(index).build();
    }

    @Override
    public Content buildFirstContent() {
        return (Content)this.content.get(0).build();
    }

    @Override
    public Content buildLastContent() {
        return (Content)this.content.get(this.content.size() - 1).build();
    }

    @Override
    public Content buildMatchingContent(Predicate<VisitableBuilder<? extends Content, ?>> predicate) {
        for (VisitableBuilder<Content, ?> item : this.content) {
            if (!predicate.test(item)) continue;
            return (Content)item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContent(Predicate<VisitableBuilder<? extends Content, ?>> predicate) {
        for (VisitableBuilder<? extends Content, ?> visitableBuilder : this.content) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContent(List<Content> content) {
        if (content != null) {
            this.content = new ArrayList();
            for (Content item : content) {
                this.addToContent(item);
            }
        } else {
            this.content = null;
        }
        return (A)this;
    }

    @Override
    public A withContent(Content ... content) {
        if (this.content != null) {
            this.content.clear();
        }
        if (content != null) {
            for (Content item : content) {
                this.addToContent(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    @Override
    public A addToFileContent(Integer index, FileContent item) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        FileContentBuilder builder = new FileContentBuilder(item);
        this._visitables.get("content").add(index >= 0 ? index.intValue() : this._visitables.get("content").size(), builder);
        this.content.add(index >= 0 ? index.intValue() : this.content.size(), builder);
        return (A)this;
    }

    @Override
    public A setToFileContent(Integer index, FileContent item) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        FileContentBuilder builder = new FileContentBuilder(item);
        if (index < 0 || index >= this._visitables.get("content").size()) {
            this._visitables.get("content").add(builder);
        } else {
            this._visitables.get("content").set(index, builder);
        }
        if (index < 0 || index >= this.content.size()) {
            this.content.add(builder);
        } else {
            this.content.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFileContent(FileContent ... items) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        for (FileContent item : items) {
            FileContentBuilder builder = new FileContentBuilder(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFileContent(Collection<FileContent> items) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        for (FileContent item : items) {
            FileContentBuilder builder = new FileContentBuilder(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFileContent(FileContent ... items) {
        for (FileContent item : items) {
            FileContentBuilder builder = new FileContentBuilder(item);
            this._visitables.get("content").remove(builder);
            if (this.content == null) continue;
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFileContent(Collection<FileContent> items) {
        for (FileContent item : items) {
            FileContentBuilder builder = new FileContentBuilder(item);
            this._visitables.get("content").remove(builder);
            if (this.content == null) continue;
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFileContent(Predicate<VisitableBuilder<? extends Content, ?>> predicate) {
        if (this.content == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<Content, ?>> each = this.content.iterator();
        Object visitables = this._visitables.get("content");
        while (each.hasNext()) {
            VisitableBuilder<? extends Content, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public BuildpackFluent.FileContentNested<A> addNewFileContent() {
        return new FileContentNestedImpl();
    }

    @Override
    public BuildpackFluent.FileContentNested<A> addNewFileContentLike(FileContent item) {
        return new FileContentNestedImpl(-1, item);
    }

    @Override
    public A addNewFileContent(File file) {
        return this.addToFileContent(new FileContent(file));
    }

    @Override
    public A addNewFileContent(String prefix, File file) {
        return this.addToFileContent(new FileContent(prefix, file));
    }

    @Override
    public BuildpackFluent.FileContentNested<A> setNewFileContentLike(Integer index, FileContent item) {
        return new FileContentNestedImpl(index, item);
    }

    @Override
    public A addToStreamContent(Integer index, StreamContent item) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        StreamContentBuilder builder = new StreamContentBuilder(item);
        this._visitables.get("content").add(index >= 0 ? index.intValue() : this._visitables.get("content").size(), builder);
        this.content.add(index >= 0 ? index.intValue() : this.content.size(), builder);
        return (A)this;
    }

    @Override
    public A setToStreamContent(Integer index, StreamContent item) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        StreamContentBuilder builder = new StreamContentBuilder(item);
        if (index < 0 || index >= this._visitables.get("content").size()) {
            this._visitables.get("content").add(builder);
        } else {
            this._visitables.get("content").set(index, builder);
        }
        if (index < 0 || index >= this.content.size()) {
            this.content.add(builder);
        } else {
            this.content.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStreamContent(StreamContent ... items) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        for (StreamContent item : items) {
            StreamContentBuilder builder = new StreamContentBuilder(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStreamContent(Collection<StreamContent> items) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        for (StreamContent item : items) {
            StreamContentBuilder builder = new StreamContentBuilder(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStreamContent(StreamContent ... items) {
        for (StreamContent item : items) {
            StreamContentBuilder builder = new StreamContentBuilder(item);
            this._visitables.get("content").remove(builder);
            if (this.content == null) continue;
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStreamContent(Collection<StreamContent> items) {
        for (StreamContent item : items) {
            StreamContentBuilder builder = new StreamContentBuilder(item);
            this._visitables.get("content").remove(builder);
            if (this.content == null) continue;
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromStreamContent(Predicate<VisitableBuilder<? extends Content, ?>> predicate) {
        if (this.content == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<Content, ?>> each = this.content.iterator();
        Object visitables = this._visitables.get("content");
        while (each.hasNext()) {
            VisitableBuilder<? extends Content, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public BuildpackFluent.StreamContentNested<A> addNewStreamContent() {
        return new StreamContentNestedImpl();
    }

    @Override
    public BuildpackFluent.StreamContentNested<A> addNewStreamContentLike(StreamContent item) {
        return new StreamContentNestedImpl(-1, item);
    }

    @Override
    public BuildpackFluent.StreamContentNested<A> setNewStreamContentLike(Integer index, StreamContent item) {
        return new StreamContentNestedImpl(index, item);
    }

    @Override
    public A addToStringContent(Integer index, StringContent item) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        StringContentBuilder builder = new StringContentBuilder(item);
        this._visitables.get("content").add(index >= 0 ? index.intValue() : this._visitables.get("content").size(), builder);
        this.content.add(index >= 0 ? index.intValue() : this.content.size(), builder);
        return (A)this;
    }

    @Override
    public A setToStringContent(Integer index, StringContent item) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        StringContentBuilder builder = new StringContentBuilder(item);
        if (index < 0 || index >= this._visitables.get("content").size()) {
            this._visitables.get("content").add(builder);
        } else {
            this._visitables.get("content").set(index, builder);
        }
        if (index < 0 || index >= this.content.size()) {
            this.content.add(builder);
        } else {
            this.content.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStringContent(StringContent ... items) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        for (StringContent item : items) {
            StringContentBuilder builder = new StringContentBuilder(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStringContent(Collection<StringContent> items) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        for (StringContent item : items) {
            StringContentBuilder builder = new StringContentBuilder(item);
            this._visitables.get("content").add(builder);
            this.content.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStringContent(StringContent ... items) {
        for (StringContent item : items) {
            StringContentBuilder builder = new StringContentBuilder(item);
            this._visitables.get("content").remove(builder);
            if (this.content == null) continue;
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStringContent(Collection<StringContent> items) {
        for (StringContent item : items) {
            StringContentBuilder builder = new StringContentBuilder(item);
            this._visitables.get("content").remove(builder);
            if (this.content == null) continue;
            this.content.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromStringContent(Predicate<VisitableBuilder<? extends Content, ?>> predicate) {
        if (this.content == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<Content, ?>> each = this.content.iterator();
        Object visitables = this._visitables.get("content");
        while (each.hasNext()) {
            VisitableBuilder<? extends Content, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public BuildpackFluent.StringContentNested<A> addNewStringContent() {
        return new StringContentNestedImpl();
    }

    @Override
    public BuildpackFluent.StringContentNested<A> addNewStringContentLike(StringContent item) {
        return new StringContentNestedImpl(-1, item);
    }

    @Override
    public A addNewStringContent(String path, String content) {
        return this.addToStringContent(new StringContent(path, content));
    }

    @Override
    public BuildpackFluent.StringContentNested<A> setNewStringContentLike(Integer index, StringContent item) {
        return new StringContentNestedImpl(index, item);
    }

    @Override
    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    @Override
    public A withDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
        return (A)this;
    }

    @Override
    public Boolean hasDockerClient() {
        return this.dockerClient != null;
    }

    @Override
    @Deprecated
    public Logger getLogger() {
        return this.logger != null ? (Logger)this.logger.build() : null;
    }

    @Override
    public Logger buildLogger() {
        return this.logger != null ? (Logger)this.logger.build() : null;
    }

    @Override
    public A withLogger(Logger logger) {
        if (logger instanceof SystemLogger) {
            this.logger = new SystemLoggerBuilder((SystemLogger)logger);
            this._visitables.get("logger").add(this.logger);
        }
        if (logger instanceof Slf4jLogger) {
            this.logger = new Slf4jLoggerBuilder((Slf4jLogger)logger);
            this._visitables.get("logger").add(this.logger);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogger() {
        return this.logger != null;
    }

    @Override
    public A withSystemLogger(SystemLogger systemLogger) {
        this._visitables.get("logger").remove(this.logger);
        if (systemLogger != null) {
            this.logger = new SystemLoggerBuilder(systemLogger);
            this._visitables.get("logger").add(this.logger);
        }
        return (A)this;
    }

    @Override
    public BuildpackFluent.SystemLoggerNested<A> withNewSystemLogger() {
        return new SystemLoggerNestedImpl();
    }

    @Override
    public BuildpackFluent.SystemLoggerNested<A> withNewSystemLoggerLike(SystemLogger item) {
        return new SystemLoggerNestedImpl(item);
    }

    @Override
    public A withNewSystemLogger(boolean ansiColorEnabled) {
        return this.withSystemLogger(new SystemLogger(ansiColorEnabled));
    }

    @Override
    public A withSlf4jLogger(Slf4jLogger slf4jLogger) {
        this._visitables.get("logger").remove(this.logger);
        if (slf4jLogger != null) {
            this.logger = new Slf4jLoggerBuilder(slf4jLogger);
            this._visitables.get("logger").add(this.logger);
        }
        return (A)this;
    }

    @Override
    public BuildpackFluent.Slf4jLoggerNested<A> withNewSlf4jLogger() {
        return new Slf4jLoggerNestedImpl();
    }

    @Override
    public BuildpackFluent.Slf4jLoggerNested<A> withNewSlf4jLoggerLike(Slf4jLogger item) {
        return new Slf4jLoggerNestedImpl(item);
    }

    @Override
    public A withNewSlf4jLogger(String name) {
        return this.withSlf4jLogger(new Slf4jLogger(name));
    }

    @Override
    public A withNewSlf4jLogger(Class c) {
        return this.withSlf4jLogger(new Slf4jLogger(c));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildpackFluentImpl that = (BuildpackFluentImpl)o;
        if (this.buildImage != null ? !this.buildImage.equals(that.buildImage) : that.buildImage != null) {
            return false;
        }
        if (this.finalImage != null ? !this.finalImage.equals(that.finalImage) : that.finalImage != null) {
            return false;
        }
        if (this.runImage != null ? !this.runImage.equals(that.runImage) : that.runImage != null) {
            return false;
        }
        if (this.pullTimeoutSeconds != null ? !this.pullTimeoutSeconds.equals(that.pullTimeoutSeconds) : that.pullTimeoutSeconds != null) {
            return false;
        }
        if (this.dockerHost != null ? !this.dockerHost.equals(that.dockerHost) : that.dockerHost != null) {
            return false;
        }
        if (this.useDaemon != that.useDaemon) {
            return false;
        }
        if (this.buildCacheVolumeName != null ? !this.buildCacheVolumeName.equals(that.buildCacheVolumeName) : that.buildCacheVolumeName != null) {
            return false;
        }
        if (this.removeBuildCacheAfterBuild != that.removeBuildCacheAfterBuild) {
            return false;
        }
        if (this.launchCacheVolumeName != null ? !this.launchCacheVolumeName.equals(that.launchCacheVolumeName) : that.launchCacheVolumeName != null) {
            return false;
        }
        if (this.removeLaunchCacheAfterBuild != that.removeLaunchCacheAfterBuild) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.useTimestamps != that.useTimestamps) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (this.dockerClient != null ? !this.dockerClient.equals(that.dockerClient) : that.dockerClient != null) {
            return false;
        }
        return !(this.logger != null ? !this.logger.equals(that.logger) : that.logger != null);
    }

    public int hashCode() {
        return Objects.hash(this.buildImage, this.finalImage, this.runImage, this.pullTimeoutSeconds, this.dockerHost, this.useDaemon, this.buildCacheVolumeName, this.removeBuildCacheAfterBuild, this.launchCacheVolumeName, this.removeLaunchCacheAfterBuild, this.logLevel, this.useTimestamps, this.environment, this.content, this.dockerClient, this.logger, super.hashCode());
    }

    public class Slf4jLoggerNestedImpl<N>
    extends Slf4jLoggerFluentImpl<BuildpackFluent.Slf4jLoggerNested<N>>
    implements BuildpackFluent.Slf4jLoggerNested<N>,
    Nested<N> {
        Slf4jLoggerBuilder builder;

        Slf4jLoggerNestedImpl(Slf4jLogger item) {
            this.builder = new Slf4jLoggerBuilder(this, item);
        }

        Slf4jLoggerNestedImpl() {
            this.builder = new Slf4jLoggerBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildpackFluentImpl.this.withLogger(this.builder.build());
        }

        @Override
        public N endSlf4jLogger() {
            return this.and();
        }
    }

    public class SystemLoggerNestedImpl<N>
    extends SystemLoggerFluentImpl<BuildpackFluent.SystemLoggerNested<N>>
    implements BuildpackFluent.SystemLoggerNested<N>,
    Nested<N> {
        SystemLoggerBuilder builder;

        SystemLoggerNestedImpl(SystemLogger item) {
            this.builder = new SystemLoggerBuilder(this, item);
        }

        SystemLoggerNestedImpl() {
            this.builder = new SystemLoggerBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildpackFluentImpl.this.withLogger(this.builder.build());
        }

        @Override
        public N endSystemLogger() {
            return this.and();
        }
    }

    public class StringContentNestedImpl<N>
    extends StringContentFluentImpl<BuildpackFluent.StringContentNested<N>>
    implements BuildpackFluent.StringContentNested<N>,
    Nested<N> {
        StringContentBuilder builder;
        Integer index;

        StringContentNestedImpl(Integer index, StringContent item) {
            this.index = index;
            this.builder = new StringContentBuilder(this, item);
        }

        StringContentNestedImpl() {
            this.index = -1;
            this.builder = new StringContentBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildpackFluentImpl.this.setToContent(this.index, this.builder.build());
        }

        @Override
        public N endStringContent() {
            return this.and();
        }
    }

    public class StreamContentNestedImpl<N>
    extends StreamContentFluentImpl<BuildpackFluent.StreamContentNested<N>>
    implements BuildpackFluent.StreamContentNested<N>,
    Nested<N> {
        StreamContentBuilder builder;
        Integer index;

        StreamContentNestedImpl(Integer index, StreamContent item) {
            this.index = index;
            this.builder = new StreamContentBuilder(this, item);
        }

        StreamContentNestedImpl() {
            this.index = -1;
            this.builder = new StreamContentBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildpackFluentImpl.this.setToContent(this.index, this.builder.build());
        }

        @Override
        public N endStreamContent() {
            return this.and();
        }
    }

    public class FileContentNestedImpl<N>
    extends FileContentFluentImpl<BuildpackFluent.FileContentNested<N>>
    implements BuildpackFluent.FileContentNested<N>,
    Nested<N> {
        FileContentBuilder builder;
        Integer index;

        FileContentNestedImpl(Integer index, FileContent item) {
            this.index = index;
            this.builder = new FileContentBuilder(this, item);
        }

        FileContentNestedImpl() {
            this.index = -1;
            this.builder = new FileContentBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildpackFluentImpl.this.setToContent(this.index, this.builder.build());
        }

        @Override
        public N endFileContent() {
            return this.and();
        }
    }
}

