/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerUtils {
    private static final Logger log = LoggerFactory.getLogger(ContainerUtils.class);

    public static String createContainer(DockerClient dc, String imageReference, VolumeBind ... volumes) {
        return ContainerUtils.createContainer(dc, imageReference, null, volumes);
    }

    private static Bind createBind(VolumeBind vb) {
        return new Bind(vb.volumeName, new Volume(vb.mountPath));
    }

    public static String createContainer(DockerClient dc, String imageReference, List<String> command, VolumeBind ... volumes) {
        CreateContainerCmd ccc = dc.createContainerCmd(imageReference);
        if (volumes != null) {
            ArrayList<Bind> binds = new ArrayList<Bind>();
            for (VolumeBind vb : volumes) {
                Bind bind = ContainerUtils.createBind(vb);
                binds.add(bind);
            }
            ccc.getHostConfig().withBinds(binds);
        }
        ccc.withUser("root");
        ccc.withEnv(new String[]{"CNB_PLATFORM_API=0.4", "CNB_REGISTRY_AUTH={}"});
        if (command != null) {
            ccc.withCmd(command);
        }
        CreateContainerResponse ccr = ccc.exec();
        return ccr.getId();
    }

    public static void removeContainer(DockerClient dc, String containerId) {
        dc.removeContainerCmd(containerId).exec();
    }

    public static void addContentToContainer(DockerClient dc, String containerId, List<ContainerEntry> entries) {
        ContainerUtils.addContentToContainer(dc, containerId, entries != null ? entries.toArray(new ContainerEntry[entries.size()]) : new ContainerEntry[]{});
    }

    public static void addContentToContainer(DockerClient dc, String containerId, ContainerEntry ... entries) {
        ContainerUtils.addContentToContainer(dc, containerId, "", (Integer)0, (Integer)0, entries);
    }

    public static void addContentToContainer(DockerClient dc, String containerId, String pathInContainer, Integer userId, Integer groupId, File content) {
        ContainerUtils.addContentToContainer(dc, containerId, pathInContainer, userId, groupId, new FileContent("", content).getContainerEntries());
    }

    public static void addContentToContainer(DockerClient dc, String containerId, String pathInContainer, Integer userId, Integer groupId, String name, String content) {
        ContainerUtils.addContentToContainer(dc, containerId, pathInContainer, userId, groupId, new StringContent(name, content).getContainerEntries());
    }

    private static void addParents(TarArchiveOutputStream tout, Set<String> seenDirs, int uid, int gid, String path) {
        try {
            String parent;
            boolean unknown;
            if (path.contains("/") && (unknown = seenDirs.add(parent = path.substring(0, path.lastIndexOf("/"))))) {
                ContainerUtils.addParents(tout, seenDirs, uid, gid, parent);
                log.debug("adding " + parent + "/");
                TarArchiveEntry tae = new TarArchiveEntry(parent + "/");
                tae.setSize(0L);
                tae.setUserId(uid);
                tae.setGroupId(gid);
                tout.putArchiveEntry((ArchiveEntry)tae);
                tout.closeArchiveEntry();
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    public static void addContentToContainer(DockerClient dc, String containerId, String pathInContainer, Integer userId, Integer groupId, List<ContainerEntry> entries) {
        ContainerUtils.addContentToContainer(dc, containerId, pathInContainer, userId, groupId, entries != null ? entries.toArray(new ContainerEntry[entries.size()]) : new ContainerEntry[]{});
    }

    public static void addContentToContainer(final DockerClient dc, final String containerId, String pathInContainer, Integer userId, Integer groupId, final ContainerEntry ... entries) {
        final HashSet<String> seenDirs = new HashSet<String>();
        seenDirs.add("");
        final String path = !pathInContainer.isEmpty() && pathInContainer.endsWith("/") ? pathInContainer.substring(0, pathInContainer.length() - 1) : pathInContainer;
        final int uid = userId != null ? userId : 0;
        final int gid = groupId != null ? groupId : 0;
        try (final PipedInputStream in = new PipedInputStream(4096);
             final PipedOutputStream out = new PipedOutputStream(in);){
            final AtomicReference writerException = new AtomicReference();
            Runnable writer = new Runnable(){

                @Override
                public void run() {
                    try (TarArchiveOutputStream tout = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(out)));){
                        tout.setLongFileMode(3);
                        for (ContainerEntry ve : entries) {
                            String entryPath = ve.getPath();
                            if (entryPath == null || entryPath.isEmpty()) {
                                throw new IOException("Error path was empty");
                            }
                            if (entryPath.startsWith("/")) {
                                entryPath = entryPath.substring(1);
                            }
                            String pathWithEntry = path + "/" + entryPath;
                            ContainerUtils.addParents(tout, seenDirs, uid, gid, pathWithEntry);
                            log.debug("adding " + pathWithEntry);
                            TarArchiveEntry tae = new TarArchiveEntry(pathWithEntry);
                            tae.setSize(ve.getSize());
                            tae.setUserId(uid);
                            tae.setGroupId(gid);
                            tout.putArchiveEntry((ArchiveEntry)tae);
                            ContainerEntry.DataSupplier cs = ve.getDataSupplier();
                            if (cs == null) {
                                throw new IOException("Error DataSupplier was not provided");
                            }
                            try (InputStream is = ve.getDataSupplier().getData();){
                                if (is == null) {
                                    throw new IOException("Error DataSupplier gave null for getData");
                                }
                                ContainerUtils.copy(is, (OutputStream)tout);
                            }
                            tout.closeArchiveEntry();
                        }
                    }
                    catch (Exception e) {
                        writerException.set(e);
                    }
                }
            };
            Runnable reader = new Runnable(){

                @Override
                public void run() {
                    dc.copyArchiveToContainerCmd(containerId).withRemotePath("/").withTarInputStream((InputStream)in).exec();
                }
            };
            Thread t1 = new Thread(writer);
            Thread t2 = new Thread(reader);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (InterruptedException ie) {
                throw BuildpackException.launderThrowable(ie);
            }
            Exception wio = (Exception)writerException.get();
            if (wio != null) {
                throw BuildpackException.launderThrowable(wio);
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    private static final void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[8192];
        try {
            int length;
            while ((length = in.read(buf)) > 0) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }
}

