/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClientUtils {
    private static final Logger log = LoggerFactory.getLogger(DockerClientUtils.class);

    public static DockerClient getDockerClient() {
        return DockerClientUtils.getDockerClient(DockerClientUtils.getDockerHost());
    }

    public static DockerClient getDockerClient(String dockerHost) {
        if (dockerHost == null || dockerHost.isEmpty()) {
            return DockerClientUtils.getDockerClient(DockerClientUtils.getDockerHost());
        }
        log.debug("Using dockerhost " + dockerHost);
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
        return dockerClient;
    }

    public static String getDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost == null) {
            dockerHost = SystemUtils.IS_OS_WINDOWS ? "npipe:////./pipe/docker_engine" : "unix:///var/run/docker.sock";
        }
        return dockerHost;
    }
}

