/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.Content;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FileContent
implements Content {
    private static final String DEFAULT_PREFIX = "";
    private static final String UNIX_FILE_SEPARATOR = "/";
    private static final String NON_UNIX_FILE_SEPARATOR = "\\";
    private final String prefix;
    private final File file;
    private final File root;

    public FileContent(File file) {
        this(DEFAULT_PREFIX, file);
    }

    public FileContent(String prefix, File file) {
        this(prefix, file, null);
    }

    private FileContent(String prefix, File file, File root) {
        this.prefix = prefix;
        this.file = file;
        this.root = root;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public List<ContainerEntry> getContainerEntries() {
        if (!this.file.exists()) {
            return Collections.emptyList();
        }
        if (this.file.isFile() && !this.file.isDirectory()) {
            return Arrays.asList(new ContainerEntry(){

                @Override
                public long getSize() {
                    try {
                        return Files.size(FileContent.this.file.toPath());
                    }
                    catch (IOException e) {
                        throw BuildpackException.launderThrowable(e);
                    }
                }

                @Override
                public String getPath() {
                    if (FileContent.this.root == null) {
                        return FileContent.this.prefix + FileContent.UNIX_FILE_SEPARATOR + FileContent.this.file.getName();
                    }
                    return FileContent.this.prefix + FileContent.this.root.toPath().relativize(FileContent.this.file.toPath()).toString().replace(FileContent.NON_UNIX_FILE_SEPARATOR, FileContent.UNIX_FILE_SEPARATOR);
                }

                @Override
                public ContainerEntry.DataSupplier getDataSupplier() {
                    final Path p = FileContent.this.file.toPath();
                    return new ContainerEntry.DataSupplier(){

                        @Override
                        public InputStream getData() {
                            try {
                                return new BufferedInputStream(Files.newInputStream(p, new OpenOption[0]));
                            }
                            catch (IOException e) {
                                throw BuildpackException.launderThrowable(e);
                            }
                        }
                    };
                }
            });
        }
        if (this.file.isDirectory()) {
            try {
                return Files.walk(this.file.toPath(), new FileVisitOption[0]).filter(p -> !p.toFile().isDirectory()).flatMap(p -> new FileContent(this.prefix, p.toFile(), this.file).getContainerEntries().stream()).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw BuildpackException.launderThrowable(e);
            }
        }
        return Collections.emptyList();
    }
}

