/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import java.io.File;
import java.util.List;

public class VolumeUtils {
    public static boolean createVolumeIfRequired(DockerClient dc, String volumeName) {
        if (!VolumeUtils.exists(dc, volumeName)) {
            return VolumeUtils.internalCreateVolume(dc, volumeName);
        }
        return true;
    }

    public static boolean exists(DockerClient dc, String volumeName) {
        try {
            dc.inspectVolumeCmd(volumeName).exec();
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void removeVolume(DockerClient dc, String volumeName) {
        dc.removeVolumeCmd(volumeName).exec();
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String pathInVolume, File content) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, new FileContent("/volumecontent", content).getContainerEntries());
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String name, String content) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, new StringContent("/volumecontent/" + name, content).getContainerEntries());
    }

    private static boolean internalCreateVolume(DockerClient dc, String volumeName) {
        dc.createVolumeCmd().withName(volumeName).exec();
        return VolumeUtils.exists(dc, volumeName);
    }

    private static boolean internalAddContentToVolume(DockerClient dc, String volumeName, List<ContainerEntry> entries) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, entries.toArray(new ContainerEntry[entries.size()]));
    }

    private static boolean internalAddContentToVolume(DockerClient dc, String volumeName, ContainerEntry ... entries) {
        String dummyId = ContainerUtils.createContainer(dc, "tianon/true", new VolumeBind(volumeName, "/volumecontent"));
        ContainerUtils.addContentToContainer(dc, dummyId, entries);
        ContainerUtils.removeContainer(dc, dummyId);
        return true;
    }
}

