package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import com.github.dockerjava.api.DockerClient;
import dev.snowdrop.buildpack.builder.Nested;
import java.util.ArrayList;
import dev.snowdrop.buildpack.docker.FileContentFluentImpl;
import java.lang.String;
import dev.snowdrop.buildpack.docker.StringContentBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import dev.snowdrop.buildpack.docker.StreamContentFluentImpl;
import java.lang.Deprecated;
import dev.snowdrop.buildpack.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import dev.snowdrop.buildpack.docker.StringContentFluentImpl;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.StreamContent;
import java.lang.Integer;
import dev.snowdrop.buildpack.docker.StreamContentBuilder;
import dev.snowdrop.buildpack.docker.Content;
import java.util.Collection;
import java.lang.Class;
import java.lang.Object;
import dev.snowdrop.buildpack.docker.FileContentBuilder;
import java.io.File;
import java.util.Map;

 /**
  * Generated
  */
public class BuildpackFluentImpl<A extends dev.snowdrop.buildpack.BuildpackFluent<A>> extends dev.snowdrop.buildpack.builder.BaseFluent<A> implements dev.snowdrop.buildpack.BuildpackFluent<A>{
  public BuildpackFluentImpl() {
  }
  public BuildpackFluentImpl(dev.snowdrop.buildpack.Buildpack instance) {
    this.withBuilderImage(instance.getBuilderImage()); 
    this.withRunImage(instance.getRunImage()); 
    this.withFinalImage(instance.getFinalImage()); 
    this.withPullTimeoutSeconds(instance.getPullTimeoutSeconds()); 
    this.withDockerHost(instance.getDockerHost()); 
    this.withUseDaemon(instance.getUseDaemon()); 
    this.withBuildCacheVolumeName(instance.getBuildCacheVolumeName()); 
    this.withRemoveBuildCacheAfterBuild(instance.getRemoveBuildCacheAfterBuild()); 
    this.withLaunchCacheVolumeName(instance.getLaunchCacheVolumeName()); 
    this.withRemoveLaunchCacheAfterBuild(instance.getRemoveLaunchCacheAfterBuild()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withUseTimestamps(instance.getUseTimestamps()); 
    this.withEnvironment(instance.getEnvironment()); 
    this.withContent(instance.getContent()); 
    this.withDockerClient(instance.getDockerClient()); 
    this.withLogger(instance.getLogger()); 
  }
  private java.lang.String builderImage;
  private java.lang.String finalImage;
  private java.lang.String runImage;
  private java.lang.Integer pullTimeoutSeconds;
  private java.lang.String dockerHost;
  private boolean useDaemon;
  private java.lang.String buildCacheVolumeName;
  private boolean removeBuildCacheAfterBuild;
  private java.lang.String launchCacheVolumeName;
  private boolean removeLaunchCacheAfterBuild;
  private java.lang.String logLevel;
  private boolean useTimestamps;
  private java.util.Map<java.lang.String,java.lang.String> environment;
  private java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> content;
  private com.github.dockerjava.api.DockerClient dockerClient;
  private dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.Logger,?> logger;
  public java.lang.String getBuilderImage() {
    return this.builderImage;
  }
  public A withBuilderImage(java.lang.String builderImage) {
    this.builderImage=builderImage; return (A) this;
  }
  public java.lang.Boolean hasBuilderImage() {
    return this.builderImage != null;
  }
  public java.lang.String getFinalImage() {
    return this.finalImage;
  }
  public A withFinalImage(java.lang.String finalImage) {
    this.finalImage=finalImage; return (A) this;
  }
  public java.lang.Boolean hasFinalImage() {
    return this.finalImage != null;
  }
  public java.lang.String getRunImage() {
    return this.runImage;
  }
  public A withRunImage(java.lang.String runImage) {
    this.runImage=runImage; return (A) this;
  }
  public java.lang.Boolean hasRunImage() {
    return this.runImage != null;
  }
  public java.lang.Integer getPullTimeoutSeconds() {
    return this.pullTimeoutSeconds;
  }
  public A withPullTimeoutSeconds(java.lang.Integer pullTimeoutSeconds) {
    this.pullTimeoutSeconds=pullTimeoutSeconds; return (A) this;
  }
  public java.lang.Boolean hasPullTimeoutSeconds() {
    return this.pullTimeoutSeconds != null;
  }
  public java.lang.String getDockerHost() {
    return this.dockerHost;
  }
  public A withDockerHost(java.lang.String dockerHost) {
    this.dockerHost=dockerHost; return (A) this;
  }
  public java.lang.Boolean hasDockerHost() {
    return this.dockerHost != null;
  }
  public boolean isUseDaemon() {
    return this.useDaemon;
  }
  public A withUseDaemon(boolean useDaemon) {
    this.useDaemon=useDaemon; return (A) this;
  }
  public java.lang.Boolean hasUseDaemon() {
    return true;
  }
  public java.lang.String getBuildCacheVolumeName() {
    return this.buildCacheVolumeName;
  }
  public A withBuildCacheVolumeName(java.lang.String buildCacheVolumeName) {
    this.buildCacheVolumeName=buildCacheVolumeName; return (A) this;
  }
  public java.lang.Boolean hasBuildCacheVolumeName() {
    return this.buildCacheVolumeName != null;
  }
  public boolean isRemoveBuildCacheAfterBuild() {
    return this.removeBuildCacheAfterBuild;
  }
  public A withRemoveBuildCacheAfterBuild(boolean removeBuildCacheAfterBuild) {
    this.removeBuildCacheAfterBuild=removeBuildCacheAfterBuild; return (A) this;
  }
  public java.lang.Boolean hasRemoveBuildCacheAfterBuild() {
    return true;
  }
  public java.lang.String getLaunchCacheVolumeName() {
    return this.launchCacheVolumeName;
  }
  public A withLaunchCacheVolumeName(java.lang.String launchCacheVolumeName) {
    this.launchCacheVolumeName=launchCacheVolumeName; return (A) this;
  }
  public java.lang.Boolean hasLaunchCacheVolumeName() {
    return this.launchCacheVolumeName != null;
  }
  public boolean isRemoveLaunchCacheAfterBuild() {
    return this.removeLaunchCacheAfterBuild;
  }
  public A withRemoveLaunchCacheAfterBuild(boolean removeLaunchCacheAfterBuild) {
    this.removeLaunchCacheAfterBuild=removeLaunchCacheAfterBuild; return (A) this;
  }
  public java.lang.Boolean hasRemoveLaunchCacheAfterBuild() {
    return true;
  }
  public java.lang.String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(java.lang.String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public java.lang.Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public boolean isUseTimestamps() {
    return this.useTimestamps;
  }
  public A withUseTimestamps(boolean useTimestamps) {
    this.useTimestamps=useTimestamps; return (A) this;
  }
  public java.lang.Boolean hasUseTimestamps() {
    return true;
  }
  public A addToEnvironment(java.lang.String key,java.lang.String value) {
    if(this.environment == null && key != null && value != null) { this.environment = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.environment.put(key, value);} return (A)this;
  }
  public A addToEnvironment(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.environment == null && map != null) { this.environment = new java.util.LinkedHashMap(); }
    if(map != null) { this.environment.putAll(map);} return (A)this;
  }
  public A removeFromEnvironment(java.lang.String key) {
    if(this.environment == null) { return (A) this; }
    if(key != null && this.environment != null) {this.environment.remove(key);} return (A)this;
  }
  public A removeFromEnvironment(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.environment == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.environment != null){this.environment.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getEnvironment() {
    return this.environment;
  }
  public <K,V>A withEnvironment(java.util.Map<java.lang.String,java.lang.String> environment) {
    if (environment == null) { this.environment =  null;} else {this.environment = new java.util.LinkedHashMap(environment);} return (A) this;
  }
  public java.lang.Boolean hasEnvironment() {
    return this.environment != null;
  }
  public A addToContent(dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    _visitables.get("content").add(builder);this.content.add(builder); return (A)this;
  }
  public A addToContent(java.lang.Integer index,dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    _visitables.get("content").add(index, builder);this.content.add(index, builder); return (A)this;
  }
  public A addToContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.Content item) {
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){addToFileContent(index, (dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){addToStreamContent(index, (dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){addToStringContent(index, (dev.snowdrop.buildpack.docker.StringContent)item);}

    return (A)this;
  }
  public A setToContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.Content item) {
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){setToFileContent(index, (dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){setToStreamContent(index, (dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){setToStringContent(index, (dev.snowdrop.buildpack.docker.StringContent)item);}

    return (A)this;
  }
  public A addToContent(dev.snowdrop.buildpack.docker.Content... items) {
     if (items != null && items.length > 0 && this.content== null) {this.content = new ArrayList<VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.Content item : items) { 
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){addToFileContent((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){addToStreamContent((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){addToStringContent((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("content").add(builder);this.content.add(builder); }
    } return (A)this;
  }
  public A addAllToContent(java.util.Collection<dev.snowdrop.buildpack.docker.Content> items) {
     if (items != null && items.size() > 0 && this.content== null) {this.content = new ArrayList<VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.Content item : items) { 
    if (item instanceof dev.snowdrop.buildpack.docker.FileContent){addToFileContent((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){addToStreamContent((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){addToStringContent((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("content").add(builder);this.content.add(builder); }
    } return (A)this;
  }
  public A removeFromContent(dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    _visitables.get("content").remove(builder);this.content.remove(builder); return (A)this;
  }
  public A removeFromContent(dev.snowdrop.buildpack.docker.Content... items) {
    for (dev.snowdrop.buildpack.docker.Content item : items) {if (item instanceof dev.snowdrop.buildpack.docker.FileContent){removeFromFileContent((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){removeFromStreamContent((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){removeFromStringContent((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("content").remove(builder);this.content.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromContent(java.util.Collection<dev.snowdrop.buildpack.docker.Content> items) {
    for (dev.snowdrop.buildpack.docker.Content item : items) {if (item instanceof dev.snowdrop.buildpack.docker.FileContent){removeFromFileContent((dev.snowdrop.buildpack.docker.FileContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StreamContent){removeFromStreamContent((dev.snowdrop.buildpack.docker.StreamContent)item);}
 else if (item instanceof dev.snowdrop.buildpack.docker.StringContent){removeFromStringContent((dev.snowdrop.buildpack.docker.StringContent)item);}

    else {  VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = builderOf(item); _visitables.get("content").remove(builder);this.content.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContent instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<dev.snowdrop.buildpack.docker.Content> getContent() {
    return build(content);
  }
  public java.util.List<dev.snowdrop.buildpack.docker.Content> buildContent() {
    return build(content);
  }
  public dev.snowdrop.buildpack.docker.Content buildContent(java.lang.Integer index) {
    return this.content.get(index).build();
  }
  public dev.snowdrop.buildpack.docker.Content buildFirstContent() {
    return this.content.get(0).build();
  }
  public dev.snowdrop.buildpack.docker.Content buildLastContent() {
    return this.content.get(content.size() - 1).build();
  }
  public dev.snowdrop.buildpack.docker.Content buildMatchingContent(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    for (dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> item: content) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingContent(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    for (dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> item: content) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContent(java.util.List<dev.snowdrop.buildpack.docker.Content> content) {
    if (content != null) {this.content = new java.util.ArrayList(); for (dev.snowdrop.buildpack.docker.Content item : content){this.addToContent(item);}} else { this.content = null;} return (A) this;
  }
  public A withContent(dev.snowdrop.buildpack.docker.Content... content) {
    if (this.content != null) {this.content.clear();}
    if (content != null) {for (dev.snowdrop.buildpack.docker.Content item :content){ this.addToContent(item);}} return (A) this;
  }
  public java.lang.Boolean hasContent() {
    return content != null && !content.isEmpty();
  }
  public A addToFileContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("content").add(index >= 0 ? index : _visitables.get("content").size(), builder);this.content.add(index >= 0 ? index : content.size(), builder); return (A)this;
  }
  public A setToFileContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);
    if (index < 0 || index >= _visitables.get("content").size()) { _visitables.get("content").add(builder); } else { _visitables.get("content").set(index, builder);}
    if (index < 0 || index >= content.size()) { content.add(builder); } else { content.set(index, builder);}
     return (A)this;
  }
  public A addToFileContent(dev.snowdrop.buildpack.docker.FileContent... items) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("content").add(builder);this.content.add(builder);} return (A)this;
  }
  public A addAllToFileContent(java.util.Collection<dev.snowdrop.buildpack.docker.FileContent> items) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("content").add(builder);this.content.add(builder);} return (A)this;
  }
  public A removeFromFileContent(dev.snowdrop.buildpack.docker.FileContent... items) {
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("content").remove(builder);if (this.content != null) {this.content.remove(builder);}} return (A)this;
  }
  public A removeAllFromFileContent(java.util.Collection<dev.snowdrop.buildpack.docker.FileContent> items) {
    for (dev.snowdrop.buildpack.docker.FileContent item : items) {dev.snowdrop.buildpack.docker.FileContentBuilder builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(item);_visitables.get("content").remove(builder);if (this.content != null) {this.content.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFileContent(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    if (content == null) return (A) this;
    final Iterator<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> each = content.iterator();
    final List visitables = _visitables.get("content");
    while (each.hasNext()) {
      dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public dev.snowdrop.buildpack.BuildpackFluent.FileContentNested<A> addNewFileContent() {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.FileContentNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildpackFluent.FileContentNested<A> addNewFileContentLike(dev.snowdrop.buildpack.docker.FileContent item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.FileContentNestedImpl(-1, item);
  }
  public A addNewFileContent(java.io.File file) {
    return (A)addToFileContent(new FileContent(file));
  }
  public A addNewFileContent(java.lang.String prefix,java.io.File file) {
    return (A)addToFileContent(new FileContent(prefix, file));
  }
  public dev.snowdrop.buildpack.BuildpackFluent.FileContentNested<A> setNewFileContentLike(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.FileContentNestedImpl(index, item);
  }
  public A addToStreamContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("content").add(index >= 0 ? index : _visitables.get("content").size(), builder);this.content.add(index >= 0 ? index : content.size(), builder); return (A)this;
  }
  public A setToStreamContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);
    if (index < 0 || index >= _visitables.get("content").size()) { _visitables.get("content").add(builder); } else { _visitables.get("content").set(index, builder);}
    if (index < 0 || index >= content.size()) { content.add(builder); } else { content.set(index, builder);}
     return (A)this;
  }
  public A addToStreamContent(dev.snowdrop.buildpack.docker.StreamContent... items) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("content").add(builder);this.content.add(builder);} return (A)this;
  }
  public A addAllToStreamContent(java.util.Collection<dev.snowdrop.buildpack.docker.StreamContent> items) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("content").add(builder);this.content.add(builder);} return (A)this;
  }
  public A removeFromStreamContent(dev.snowdrop.buildpack.docker.StreamContent... items) {
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("content").remove(builder);if (this.content != null) {this.content.remove(builder);}} return (A)this;
  }
  public A removeAllFromStreamContent(java.util.Collection<dev.snowdrop.buildpack.docker.StreamContent> items) {
    for (dev.snowdrop.buildpack.docker.StreamContent item : items) {dev.snowdrop.buildpack.docker.StreamContentBuilder builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(item);_visitables.get("content").remove(builder);if (this.content != null) {this.content.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStreamContent(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    if (content == null) return (A) this;
    final Iterator<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> each = content.iterator();
    final List visitables = _visitables.get("content");
    while (each.hasNext()) {
      dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public dev.snowdrop.buildpack.BuildpackFluent.StreamContentNested<A> addNewStreamContent() {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.StreamContentNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildpackFluent.StreamContentNested<A> addNewStreamContentLike(dev.snowdrop.buildpack.docker.StreamContent item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.StreamContentNestedImpl(-1, item);
  }
  public dev.snowdrop.buildpack.BuildpackFluent.StreamContentNested<A> setNewStreamContentLike(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.StreamContentNestedImpl(index, item);
  }
  public A addToStringContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("content").add(index >= 0 ? index : _visitables.get("content").size(), builder);this.content.add(index >= 0 ? index : content.size(), builder); return (A)this;
  }
  public A setToStringContent(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);
    if (index < 0 || index >= _visitables.get("content").size()) { _visitables.get("content").add(builder); } else { _visitables.get("content").set(index, builder);}
    if (index < 0 || index >= content.size()) { content.add(builder); } else { content.set(index, builder);}
     return (A)this;
  }
  public A addToStringContent(dev.snowdrop.buildpack.docker.StringContent... items) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("content").add(builder);this.content.add(builder);} return (A)this;
  }
  public A addAllToStringContent(java.util.Collection<dev.snowdrop.buildpack.docker.StringContent> items) {
    if (this.content == null) {this.content = new java.util.ArrayList<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>>();}
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("content").add(builder);this.content.add(builder);} return (A)this;
  }
  public A removeFromStringContent(dev.snowdrop.buildpack.docker.StringContent... items) {
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("content").remove(builder);if (this.content != null) {this.content.remove(builder);}} return (A)this;
  }
  public A removeAllFromStringContent(java.util.Collection<dev.snowdrop.buildpack.docker.StringContent> items) {
    for (dev.snowdrop.buildpack.docker.StringContent item : items) {dev.snowdrop.buildpack.docker.StringContentBuilder builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(item);_visitables.get("content").remove(builder);if (this.content != null) {this.content.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStringContent(java.util.function.Predicate<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> predicate) {
    if (content == null) return (A) this;
    final Iterator<dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?>> each = content.iterator();
    final List visitables = _visitables.get("content");
    while (each.hasNext()) {
      dev.snowdrop.buildpack.builder.VisitableBuilder<? extends dev.snowdrop.buildpack.docker.Content,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public dev.snowdrop.buildpack.BuildpackFluent.StringContentNested<A> addNewStringContent() {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.StringContentNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildpackFluent.StringContentNested<A> addNewStringContentLike(dev.snowdrop.buildpack.docker.StringContent item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.StringContentNestedImpl(-1, item);
  }
  public A addNewStringContent(java.lang.String path,java.lang.String content) {
    return (A)addToStringContent(new StringContent(path, content));
  }
  public dev.snowdrop.buildpack.BuildpackFluent.StringContentNested<A> setNewStringContentLike(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.StringContentNestedImpl(index, item);
  }
  public com.github.dockerjava.api.DockerClient getDockerClient() {
    return this.dockerClient;
  }
  public A withDockerClient(com.github.dockerjava.api.DockerClient dockerClient) {
    this.dockerClient=dockerClient; return (A) this;
  }
  public java.lang.Boolean hasDockerClient() {
    return this.dockerClient != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLogger instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public dev.snowdrop.buildpack.Logger getLogger() {
    return this.logger!=null?this.logger.build():null;
  }
  public dev.snowdrop.buildpack.Logger buildLogger() {
    return this.logger!=null?this.logger.build():null;
  }
  public A withLogger(dev.snowdrop.buildpack.Logger logger) {
    if (logger instanceof dev.snowdrop.buildpack.SystemLogger){ this.logger= new dev.snowdrop.buildpack.SystemLoggerBuilder((dev.snowdrop.buildpack.SystemLogger)logger); _visitables.get("logger").add(this.logger);}
    if (logger instanceof dev.snowdrop.buildpack.Slf4jLogger){ this.logger= new dev.snowdrop.buildpack.Slf4jLoggerBuilder((dev.snowdrop.buildpack.Slf4jLogger)logger); _visitables.get("logger").add(this.logger);}
    return (A) this;
  }
  public java.lang.Boolean hasLogger() {
    return this.logger != null;
  }
  public A withSystemLogger(dev.snowdrop.buildpack.SystemLogger systemLogger) {
    _visitables.get("logger").remove(this.logger);
    if (systemLogger!=null){ this.logger= new dev.snowdrop.buildpack.SystemLoggerBuilder(systemLogger); _visitables.get("logger").add(this.logger);} return (A) this;
  }
  public dev.snowdrop.buildpack.BuildpackFluent.SystemLoggerNested<A> withNewSystemLogger() {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.SystemLoggerNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildpackFluent.SystemLoggerNested<A> withNewSystemLoggerLike(dev.snowdrop.buildpack.SystemLogger item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.SystemLoggerNestedImpl(item);
  }
  public A withNewSystemLogger(boolean ansiColorEnabled) {
    return (A)withSystemLogger(new SystemLogger(ansiColorEnabled));
  }
  public A withSlf4jLogger(dev.snowdrop.buildpack.Slf4jLogger slf4jLogger) {
    _visitables.get("logger").remove(this.logger);
    if (slf4jLogger!=null){ this.logger= new dev.snowdrop.buildpack.Slf4jLoggerBuilder(slf4jLogger); _visitables.get("logger").add(this.logger);} return (A) this;
  }
  public dev.snowdrop.buildpack.BuildpackFluent.Slf4jLoggerNested<A> withNewSlf4jLogger() {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.Slf4jLoggerNestedImpl();
  }
  public dev.snowdrop.buildpack.BuildpackFluent.Slf4jLoggerNested<A> withNewSlf4jLoggerLike(dev.snowdrop.buildpack.Slf4jLogger item) {
    return new dev.snowdrop.buildpack.BuildpackFluentImpl.Slf4jLoggerNestedImpl(item);
  }
  public A withNewSlf4jLogger(java.lang.String name) {
    return (A)withSlf4jLogger(new Slf4jLogger(name));
  }
  public A withNewSlf4jLogger(java.lang.Class c) {
    return (A)withSlf4jLogger(new Slf4jLogger(c));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildpackFluentImpl that = (BuildpackFluentImpl) o;
    if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
    if (finalImage != null ? !finalImage.equals(that.finalImage) :that.finalImage != null) return false;
    if (runImage != null ? !runImage.equals(that.runImage) :that.runImage != null) return false;
    if (pullTimeoutSeconds != null ? !pullTimeoutSeconds.equals(that.pullTimeoutSeconds) :that.pullTimeoutSeconds != null) return false;
    if (dockerHost != null ? !dockerHost.equals(that.dockerHost) :that.dockerHost != null) return false;
    if (useDaemon != that.useDaemon) return false;
    if (buildCacheVolumeName != null ? !buildCacheVolumeName.equals(that.buildCacheVolumeName) :that.buildCacheVolumeName != null) return false;
    if (removeBuildCacheAfterBuild != that.removeBuildCacheAfterBuild) return false;
    if (launchCacheVolumeName != null ? !launchCacheVolumeName.equals(that.launchCacheVolumeName) :that.launchCacheVolumeName != null) return false;
    if (removeLaunchCacheAfterBuild != that.removeLaunchCacheAfterBuild) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (useTimestamps != that.useTimestamps) return false;
    if (environment != null ? !environment.equals(that.environment) :that.environment != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (dockerClient != null ? !dockerClient.equals(that.dockerClient) :that.dockerClient != null) return false;
    if (logger != null ? !logger.equals(that.logger) :that.logger != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(builderImage,  finalImage,  runImage,  pullTimeoutSeconds,  dockerHost,  useDaemon,  buildCacheVolumeName,  removeBuildCacheAfterBuild,  launchCacheVolumeName,  removeLaunchCacheAfterBuild,  logLevel,  useTimestamps,  environment,  content,  dockerClient,  logger,  super.hashCode());
  }
  public class FileContentNestedImpl<N> extends dev.snowdrop.buildpack.docker.FileContentFluentImpl<dev.snowdrop.buildpack.BuildpackFluent.FileContentNested<N>> implements dev.snowdrop.buildpack.BuildpackFluent.FileContentNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    FileContentNestedImpl(java.lang.Integer index,dev.snowdrop.buildpack.docker.FileContent item) {
      this.index = index;
      this.builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(this, item);
    }
    FileContentNestedImpl() {
      this.index = -1;
      this.builder = new dev.snowdrop.buildpack.docker.FileContentBuilder(this);
    }
    dev.snowdrop.buildpack.docker.FileContentBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildpackFluentImpl.this.setToContent(index,builder.build());
    }
    public N endFileContent() {
      return and();
    }
    
  }
  public class StreamContentNestedImpl<N> extends dev.snowdrop.buildpack.docker.StreamContentFluentImpl<dev.snowdrop.buildpack.BuildpackFluent.StreamContentNested<N>> implements dev.snowdrop.buildpack.BuildpackFluent.StreamContentNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    StreamContentNestedImpl(java.lang.Integer index,dev.snowdrop.buildpack.docker.StreamContent item) {
      this.index = index;
      this.builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(this, item);
    }
    StreamContentNestedImpl() {
      this.index = -1;
      this.builder = new dev.snowdrop.buildpack.docker.StreamContentBuilder(this);
    }
    dev.snowdrop.buildpack.docker.StreamContentBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildpackFluentImpl.this.setToContent(index,builder.build());
    }
    public N endStreamContent() {
      return and();
    }
    
  }
  public class StringContentNestedImpl<N> extends dev.snowdrop.buildpack.docker.StringContentFluentImpl<dev.snowdrop.buildpack.BuildpackFluent.StringContentNested<N>> implements dev.snowdrop.buildpack.BuildpackFluent.StringContentNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    StringContentNestedImpl(java.lang.Integer index,dev.snowdrop.buildpack.docker.StringContent item) {
      this.index = index;
      this.builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(this, item);
    }
    StringContentNestedImpl() {
      this.index = -1;
      this.builder = new dev.snowdrop.buildpack.docker.StringContentBuilder(this);
    }
    dev.snowdrop.buildpack.docker.StringContentBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildpackFluentImpl.this.setToContent(index,builder.build());
    }
    public N endStringContent() {
      return and();
    }
    
  }
  public class SystemLoggerNestedImpl<N> extends dev.snowdrop.buildpack.SystemLoggerFluentImpl<dev.snowdrop.buildpack.BuildpackFluent.SystemLoggerNested<N>> implements dev.snowdrop.buildpack.BuildpackFluent.SystemLoggerNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    SystemLoggerNestedImpl(dev.snowdrop.buildpack.SystemLogger item) {
      this.builder = new dev.snowdrop.buildpack.SystemLoggerBuilder(this, item);
    }
    SystemLoggerNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.SystemLoggerBuilder(this);
    }
    dev.snowdrop.buildpack.SystemLoggerBuilder builder;
    public N and() {
      return (N) BuildpackFluentImpl.this.withLogger(builder.build());
    }
    public N endSystemLogger() {
      return and();
    }
    
  }
  public class Slf4jLoggerNestedImpl<N> extends dev.snowdrop.buildpack.Slf4jLoggerFluentImpl<dev.snowdrop.buildpack.BuildpackFluent.Slf4jLoggerNested<N>> implements dev.snowdrop.buildpack.BuildpackFluent.Slf4jLoggerNested<N>,dev.snowdrop.buildpack.builder.Nested<N>{
    Slf4jLoggerNestedImpl(dev.snowdrop.buildpack.Slf4jLogger item) {
      this.builder = new dev.snowdrop.buildpack.Slf4jLoggerBuilder(this, item);
    }
    Slf4jLoggerNestedImpl() {
      this.builder = new dev.snowdrop.buildpack.Slf4jLoggerBuilder(this);
    }
    dev.snowdrop.buildpack.Slf4jLoggerBuilder builder;
    public N and() {
      return (N) BuildpackFluentImpl.this.withLogger(builder.build());
    }
    public N endSlf4jLogger() {
      return and();
    }
    
  }
  
}