/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.builder;

import dev.snowdrop.buildpack.builder.TypedVisitor;
import java.util.ArrayList;
import java.util.List;

public class PathAwareTypedVisitor<V, P>
extends TypedVisitor<V> {
    List<Object> path;
    PathAwareTypedVisitor<V, P> delegate;
    Class<P> parentType;

    PathAwareTypedVisitor(List<Object> path) {
        this.path = path;
        this.delegate = this;
        this.parentType = this.getTypeArguments(PathAwareTypedVisitor.class, this.getClass()).get(1);
    }

    PathAwareTypedVisitor(List<Object> path, PathAwareTypedVisitor<V, P> delegate) {
        this.path = path;
        this.delegate = this;
        this.parentType = this.getTypeArguments(PathAwareTypedVisitor.class, delegate.getClass()).get(1);
    }

    @Override
    public void visit(V element) {
        this.delegate.path = this.path;
        this.delegate.visit(element);
    }

    PathAwareTypedVisitor<V, P> next(Object item) {
        ArrayList<Object> path = new ArrayList<Object>(this.path);
        path.add(item);
        return new PathAwareTypedVisitor<V, P>(path, this);
    }

    P getParent() {
        return (P)(this.path.size() - 2 >= 0 ? this.path.get(this.path.size() - 2) : null);
    }

    Class<P> getParentType() {
        return this.parentType != null ? this.parentType : this.delegate.getParentType();
    }

    protected Class<?> getActualParentType() {
        return this.path.size() - 2 >= 0 ? this.path.get(this.path.size() - 2).getClass() : Void.class;
    }
}

