/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.core.jdbc;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import dev.snowdrop.boot.narayana.core.jdbc.ConnectionManager;
import dev.snowdrop.boot.narayana.core.jdbc.NamedXAResource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DataSourceXAResourceRecoveryHelper
implements XAResourceRecoveryHelper,
XAResource {
    private final ConnectionManager connectionManager;
    private final String name;

    public DataSourceXAResourceRecoveryHelper(XADataSource xaDataSource, String name) {
        this(xaDataSource, null, null, name);
    }

    public DataSourceXAResourceRecoveryHelper(XADataSource xaDataSource, String user, String password, String name) {
        this.connectionManager = new ConnectionManager(xaDataSource, user, password);
        this.name = name;
    }

    public boolean initialise(String properties) {
        return true;
    }

    public XAResource[] getXAResources() {
        if (!this.connectionManager.isConnected()) {
            try {
                this.connectionManager.connect();
            }
            catch (XAException ignored) {
                return new XAResource[0];
            }
        }
        return new XAResource[]{new NamedXAResource(this, this.name)};
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            Xid[] xidArray = this.connectionManager.connectAndApply(delegate -> delegate.recover(flag));
            return xidArray;
        }
        finally {
            if (flag == 0x800000) {
                this.connectionManager.disconnect();
            }
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.start(xid, flags));
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.end(xid, flags));
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.connectionManager.connectAndApply(delegate -> delegate.prepare(xid));
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.commit(xid, onePhase));
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.rollback(xid));
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.connectionManager.connectAndApply(delegate -> delegate.isSameRM(xaResource));
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.forget(xid));
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.connectionManager.connectAndApply(XAResource::getTransactionTimeout);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.connectionManager.connectAndApply(delegate -> delegate.setTransactionTimeout(seconds));
    }
}

