/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.core.jdbc;

import com.arjuna.ats.internal.jdbc.drivers.modifiers.IsSameRMModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ModifierFactory;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.SupportsMultipleConnectionsModifier;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import dev.snowdrop.boot.narayana.core.jdbc.DataSourceXAResourceRecoveryHelper;
import dev.snowdrop.boot.narayana.core.jdbc.NarayanaDataSource;
import dev.snowdrop.boot.narayana.core.properties.RecoveryCredentialsProperties;
import dev.snowdrop.boot.narayana.core.properties.TransactionalDriverProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.jdbc.support.JdbcUtils;

public class GenericXADataSourceWrapper
implements XADataSourceWrapper {
    private final XARecoveryModule xaRecoveryModule;
    private final TransactionalDriverProperties transactionalDriverProperties;
    private final RecoveryCredentialsProperties recoveryCredentials;

    public GenericXADataSourceWrapper(XARecoveryModule xaRecoveryModule) {
        this(xaRecoveryModule, RecoveryCredentialsProperties.DEFAULT);
    }

    public GenericXADataSourceWrapper(XARecoveryModule xaRecoveryModule, RecoveryCredentialsProperties recoveryCredentials) {
        this(xaRecoveryModule, new TransactionalDriverProperties(), recoveryCredentials);
    }

    public GenericXADataSourceWrapper(XARecoveryModule xaRecoveryModule, TransactionalDriverProperties transactionalDriverProperties) {
        this(xaRecoveryModule, transactionalDriverProperties, RecoveryCredentialsProperties.DEFAULT);
    }

    public GenericXADataSourceWrapper(XARecoveryModule xaRecoveryModule, TransactionalDriverProperties transactionalDriverProperties, RecoveryCredentialsProperties recoveryCredentials) {
        this.xaRecoveryModule = xaRecoveryModule;
        this.transactionalDriverProperties = transactionalDriverProperties;
        this.recoveryCredentials = recoveryCredentials;
    }

    public DataSource wrapDataSource(XADataSource dataSource) throws Exception {
        XAResourceRecoveryHelper recoveryHelper = this.getRecoveryHelper(dataSource);
        this.xaRecoveryModule.addXAResourceRecoveryHelper(recoveryHelper);
        this.registerModifier(dataSource);
        return new NarayanaDataSource(dataSource, this.transactionalDriverProperties);
    }

    private XAResourceRecoveryHelper getRecoveryHelper(XADataSource dataSource) {
        if (this.recoveryCredentials.isValid()) {
            return new DataSourceXAResourceRecoveryHelper(dataSource, this.recoveryCredentials.getUser(), this.recoveryCredentials.getPassword(), this.transactionalDriverProperties.getName());
        }
        return new DataSourceXAResourceRecoveryHelper(dataSource, this.transactionalDriverProperties.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerModifier(XADataSource dataSource) throws SQLException {
        try (Connection conn = dataSource.getXAConnection().getConnection();){
            DatabaseMetaData metaData = conn.getMetaData();
            String driver = metaData.getDriverName();
            int major = metaData.getDriverMajorVersion();
            int minor = metaData.getDriverMinorVersion();
            switch (this.transactionalDriverProperties.getModifier()) {
                case DEFAULT: {
                    switch (DatabaseDriver.fromProductName((String)JdbcUtils.commonDatabaseName((String)metaData.getDatabaseProductName()))) {
                        case DB2: 
                        case H2: 
                        case MYSQL: 
                        case ORACLE: 
                        case SQLSERVER: {
                            ModifierFactory.putModifier((String)driver, (int)major, (int)minor, (String)IsSameRMModifier.class.getName());
                            return;
                        }
                        case POSTGRESQL: {
                            ModifierFactory.putModifier((String)driver, (int)major, (int)minor, (String)SupportsMultipleConnectionsModifier.class.getName());
                            return;
                        }
                    }
                    return;
                }
                case IS_SAME_RM: {
                    ModifierFactory.putModifier((String)driver, (int)major, (int)minor, (String)IsSameRMModifier.class.getName());
                    return;
                }
                case SUPPORTS_MULTIPLE_CONNECTIONS: {
                    ModifierFactory.putModifier((String)driver, (int)major, (int)minor, (String)SupportsMultipleConnectionsModifier.class.getName());
                    return;
                }
            }
            return;
        }
    }
}

