/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.core.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionManager;
import com.arjuna.ats.jdbc.TransactionalDriver;
import dev.snowdrop.boot.narayana.core.properties.TransactionalDriverProperties;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class NarayanaDataSource
implements DataSource {
    private final XADataSource xaDataSource;
    private final TransactionalDriverProperties transactionalDriverProperties;

    public NarayanaDataSource(XADataSource xaDataSource, TransactionalDriverProperties transactionalDriverProperties) {
        this.xaDataSource = xaDataSource;
        this.transactionalDriverProperties = transactionalDriverProperties;
    }

    private Properties createProperties() {
        Properties properties = new Properties();
        properties.put(TransactionalDriver.XADataSource, this.xaDataSource);
        properties.put("POOL_CONNECTIONS", String.valueOf(this.transactionalDriverProperties.getPool().isEnabled()));
        properties.put("MAXCONNECTIONS", (Object)this.transactionalDriverProperties.getPool().getMaxConnections());
        return properties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ConnectionManager.create((String)this.transactionalDriverProperties.getName(), (Properties)this.createProperties());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties properties = this.createProperties();
        properties.put("user", username);
        properties.put("password", password);
        return ConnectionManager.create((String)this.transactionalDriverProperties.getName(), (Properties)properties);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        if (iface.isAssignableFrom(this.xaDataSource.getClass())) {
            return (T)this.xaDataSource;
        }
        throw new SQLException(String.valueOf(this.getClass()) + " is not a wrapper for " + String.valueOf(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

