/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.core.properties;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBean;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean;
import com.arjuna.ats.jdbc.common.JDBCEnvironmentBean;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import dev.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;

public class NarayanaPropertiesInitializer
implements InitializingBean {
    private static final String HASH_ALGORITHM_FOR_SHORTENING = "SHA-224";
    private final NarayanaProperties properties;

    public NarayanaPropertiesInitializer(NarayanaProperties narayanaProperties) {
        this.properties = narayanaProperties;
    }

    public void afterPropertiesSet() {
        this.setNodeIdentifier(this.properties.getNodeIdentifier(), this.properties.isShortenNodeIdentifierIfNecessary());
        this.setXARecoveryNodes(this.properties.getXaRecoveryNodes());
        this.setObjectStoreDir(this.properties.getLogDir());
        this.setCommitOnePhase(this.properties.isOnePhaseCommit());
        this.setDefaultTimeout(this.properties.getDefaultTimeout());
        this.setPeriodicRecoveryPeriod(this.properties.getPeriodicRecoveryPeriod());
        this.setRecoveryBackoffPeriod(this.properties.getRecoveryBackoffPeriod());
        this.setExpiryScanInterval(this.properties.getExpiryScanInterval());
        this.setXaResourceOrphanFilters(this.properties.getXaResourceOrphanFilters());
        this.setXAResourceRecordWrappingPlugin(this.properties.getXaResourceRecordWrappingPlugin());
        this.setLastResourceOptimisationInterface(this.properties.getLastResourceOptimisationInterface());
        this.setCommitMarkableResourceJNDINames(this.properties.getCommitMarkableResourceJNDINames());
        this.setRecoveryModules(this.properties.getRecoveryModules());
        this.setExpiryScanners(this.properties.getExpiryScanners());
        this.setDefaultIsolationLevel(this.properties.getTransactionalDriver().getDefaultIsolationLevel().getLevel());
        this.setDefaultIsSameRMOverride(this.properties.getTransactionalDriver().isDefaultIsSameRMOverride());
    }

    private void setNodeIdentifier(String nodeIdentifier, boolean shortenNodeIdentifierIfNecessary) {
        try {
            if (nodeIdentifier != null && nodeIdentifier.getBytes(StandardCharsets.UTF_8).length > 28 && shortenNodeIdentifierIfNecessary) {
                this.getPopulator(CoreEnvironmentBean.class).setNodeIdentifier(this.shortenNodeIdentifier(nodeIdentifier));
            } else {
                this.getPopulator(CoreEnvironmentBean.class).setNodeIdentifier(nodeIdentifier);
            }
        }
        catch (CoreEnvironmentBeanException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String shortenNodeIdentifier(String nodeIdentifier) throws NoSuchAlgorithmException {
        byte[] nodeIdentifierAsBytes = nodeIdentifier.getBytes(StandardCharsets.UTF_8);
        MessageDigest messageDigest224 = MessageDigest.getInstance(HASH_ALGORITHM_FOR_SHORTENING);
        byte[] hashedByteArray = messageDigest224.digest(nodeIdentifierAsBytes);
        byte[] base64Result = Base64.getEncoder().encode(hashedByteArray);
        byte[] slice = Arrays.copyOfRange(base64Result, 0, 28);
        return new String(slice, StandardCharsets.UTF_8);
    }

    private void setXARecoveryNodes(List<String> xaRecoveryNodes) {
        if (xaRecoveryNodes.isEmpty()) {
            xaRecoveryNodes = List.of(this.getPopulator(CoreEnvironmentBean.class).getNodeIdentifier());
        }
        this.getPopulator(JTAEnvironmentBean.class).setXaRecoveryNodes(xaRecoveryNodes);
    }

    private void setObjectStoreDir(String objectStoreDir) {
        if (objectStoreDir != null) {
            this.getPopulator(ObjectStoreEnvironmentBean.class).setObjectStoreDir(objectStoreDir);
            this.getPopulator(ObjectStoreEnvironmentBean.class, "communicationStore").setObjectStoreDir(objectStoreDir);
            this.getPopulator(ObjectStoreEnvironmentBean.class, "stateStore").setObjectStoreDir(objectStoreDir);
        }
    }

    private void setCommitOnePhase(boolean isCommitOnePhase) {
        this.getPopulator(CoordinatorEnvironmentBean.class).setCommitOnePhase(isCommitOnePhase);
    }

    private void setDefaultTimeout(int defaultTimeout) {
        this.getPopulator(CoordinatorEnvironmentBean.class).setDefaultTimeout(defaultTimeout);
    }

    private void setPeriodicRecoveryPeriod(int periodicRecoveryPeriod) {
        this.getPopulator(RecoveryEnvironmentBean.class).setPeriodicRecoveryPeriod(periodicRecoveryPeriod);
    }

    private void setRecoveryBackoffPeriod(int recoveryBackoffPeriod) {
        this.getPopulator(RecoveryEnvironmentBean.class).setRecoveryBackoffPeriod(recoveryBackoffPeriod);
    }

    private void setExpiryScanInterval(int expiryScanInterval) {
        this.getPopulator(RecoveryEnvironmentBean.class).setExpiryScanInterval(expiryScanInterval);
    }

    private void setXaResourceOrphanFilters(List<String> xaResourceOrphanFilters) {
        this.getPopulator(JTAEnvironmentBean.class).setXaResourceOrphanFilterClassNames(xaResourceOrphanFilters);
    }

    private void setXAResourceRecordWrappingPlugin(String xaResourceRecordWrappingPlugin) {
        this.getPopulator(JTAEnvironmentBean.class).setXaResourceRecordWrappingPluginClassName(xaResourceRecordWrappingPlugin);
    }

    private void setLastResourceOptimisationInterface(String lastResourceOptimisationInterface) {
        this.getPopulator(JTAEnvironmentBean.class).setLastResourceOptimisationInterfaceClassName(lastResourceOptimisationInterface);
    }

    private void setCommitMarkableResourceJNDINames(List<String> commitMarkableResourceJNDINames) {
        this.getPopulator(JTAEnvironmentBean.class).setCommitMarkableResourceJNDINames(commitMarkableResourceJNDINames);
    }

    private void setRecoveryModules(List<String> recoveryModules) {
        this.getPopulator(RecoveryEnvironmentBean.class).setRecoveryModuleClassNames(recoveryModules);
    }

    private void setExpiryScanners(List<String> expiryScanners) {
        this.getPopulator(RecoveryEnvironmentBean.class).setExpiryScannerClassNames(expiryScanners);
    }

    private void setDefaultIsolationLevel(int defaultIsolationLevel) {
        this.getPopulator(JDBCEnvironmentBean.class).setIsolationLevel(defaultIsolationLevel);
    }

    private void setDefaultIsSameRMOverride(boolean defaultIsSameRMOverride) {
        this.getPopulator(JDBCEnvironmentBean.class).setDefaultIsSameRMOverride(defaultIsSameRMOverride);
    }

    private <T> T getPopulator(Class<T> beanClass) {
        return (T)BeanPopulator.getDefaultInstance(beanClass);
    }

    private <T> T getPopulator(Class<T> beanClass, String name) {
        return (T)BeanPopulator.getNamedInstance(beanClass, (String)name);
    }
}

