/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.autoconfigure;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import dev.snowdrop.boot.narayana.autoconfigure.NarayanaBeanFactoryPostProcessor;
import dev.snowdrop.boot.narayana.core.jdbc.GenericXADataSourceWrapper;
import dev.snowdrop.boot.narayana.core.jms.GenericXAConnectionFactoryWrapper;
import dev.snowdrop.boot.narayana.core.jms.PooledXAConnectionFactoryWrapper;
import dev.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import dev.snowdrop.boot.narayana.core.properties.NarayanaPropertiesInitializer;
import jakarta.jms.Message;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.File;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={NarayanaProperties.class})
@ConditionalOnProperty(prefix="spring.jta", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Transaction.class, JtaTransactionManager.class, XAResourceRecoveryRegistry.class, UserTransaction.class})
@ConditionalOnMissingBean(value={PlatformTransactionManager.class})
@AutoConfigureBefore(value={JtaAutoConfiguration.class})
public class NarayanaConfiguration {
    private final TransactionManagerCustomizers transactionManagerCustomizers;

    public NarayanaConfiguration(ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public static NarayanaBeanFactoryPostProcessor narayanaBeanFactoryPostProcessor() {
        return new NarayanaBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public NarayanaPropertiesInitializer narayanaPropertiesInitializer(NarayanaProperties properties) {
        this.initLogDir(properties);
        return new NarayanaPropertiesInitializer(properties);
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public jakarta.transaction.UserTransaction narayanaUserTransaction() {
        return UserTransaction.userTransaction();
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public jakarta.transaction.TransactionManager narayanaTransactionManager() {
        return TransactionManager.transactionManager();
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public TransactionSynchronizationRegistry narayanaTransactionSynchronizationRegistry() {
        return jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public JtaTransactionManager transactionManager(jakarta.transaction.UserTransaction userTransaction, jakarta.transaction.TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(userTransaction, transactionManager);
        jtaTransactionManager.setTransactionSynchronizationRegistry(transactionSynchronizationRegistry);
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)jtaTransactionManager);
        }
        return jtaTransactionManager;
    }

    @Bean(destroyMethod="stop")
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public RecoveryManagerService recoveryManagerService() {
        RecoveryManager.delayRecoveryManagerThread();
        RecoveryManagerService recoveryManagerService = new RecoveryManagerService();
        recoveryManagerService.create();
        recoveryManagerService.start();
        return recoveryManagerService;
    }

    @Bean
    @DependsOn(value={"recoveryManagerService"})
    @ConditionalOnMissingBean
    public XARecoveryModule xaRecoveryModule() {
        return XARecoveryModule.getRegisteredXARecoveryModule();
    }

    private void initLogDir(NarayanaProperties properties) {
        if (StringUtils.hasText((String)properties.getLogDir())) {
            return;
        }
        properties.setLogDir(this.getLogDir().getAbsolutePath());
    }

    private File getLogDir() {
        File home = new ApplicationHome().getDir();
        return new File(home, "transaction-logs");
    }

    @ConditionalOnProperty(name={"narayana.messaginghub.enabled"}, havingValue="true")
    @ConditionalOnClass(value={Message.class})
    static class PooledJmsConfiguration {
        PooledJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        public XAConnectionFactoryWrapper xaConnectionFactoryWrapper(jakarta.transaction.TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, NarayanaProperties narayanaProperties) {
            return new PooledXAConnectionFactoryWrapper(transactionManager, xaRecoveryModule, narayanaProperties.getMessaginghub(), narayanaProperties.getRecoveryJmsCredentials());
        }
    }

    @ConditionalOnProperty(name={"narayana.messaginghub.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnClass(value={Message.class})
    static class GenericJmsConfiguration {
        GenericJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        public XAConnectionFactoryWrapper xaConnectionFactoryWrapper(jakarta.transaction.TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, NarayanaProperties narayanaProperties) {
            return new GenericXAConnectionFactoryWrapper(transactionManager, xaRecoveryModule, narayanaProperties.getRecoveryJmsCredentials());
        }
    }

    static class GenericJdbcConfiguration {
        GenericJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
        public XADataSourceWrapper xaDataSourceWrapper(NarayanaProperties narayanaProperties, XARecoveryModule xaRecoveryModule) {
            return new GenericXADataSourceWrapper(xaRecoveryModule, narayanaProperties.getRecoveryDbCredentials());
        }
    }
}

